% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependence.R
\name{dependence}
\alias{dependence}
\title{Partial Dependence}
\usage{
dependence(object, data = NULL, select = NULL, interaction = FALSE,
  n = 10, intervals = c("uniform", "quantile"), stats = c(Mean =
  mean))
}
\arguments{
\item{object}{MLModelFit object.}

\item{data}{data frame containing all predictor variables.  If not specified,
the training data will be used by default.}

\item{select}{expression indicating predictor variables for which to compute
partial dependence (see \code{\link[base]{subset}} for syntax)
[default: all].}

\item{interaction}{logical indicating whether to calculate dependence on the
interacted predictors.}

\item{n}{number of predictor values at which to perform calculations.}

\item{intervals}{character string specifying whether the \code{n} values are
spaced according to variable quantiles (\code{"quantile"}) or uniformly
(\code{"uniform"}).}

\item{stats}{function or list of named functions with which to aggregate
the response variable over the non-selected predictor variables.}
}
\value{
PartialDependence class object.
}
\description{
Calculate partial dependence of a response on select predictor variables.
}
\examples{
gbmfit <- fit(Species ~ ., data = iris, model = GBMModel)
(pd <- dependence(gbmfit, select = c(Petal.Length, Petal.Width)))
plot(pd)

}
\seealso{
\code{\link{fit}}, \code{\link{plot}}
}
