% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{GetLeastContributor}
\alias{GetLeastContributor}
\title{Get least HV contributor}
\usage{
GetLeastContributor(populationObjective, reference = NULL,
  method = "exact", hypervolumeMethodParam = list())
}
\arguments{
\item{populationObjective}{The objective value of the corresponding individual}

\item{reference}{The reference point for computing HV}

\item{method}{the HV computation method}

\item{hypervolumeMethodParam}{A list of parameters to be passed to the hypervolumeMethod}
}
\value{
The index of the least contributor, an integer.
}
\description{
Get index of the individual with least hypervolume (HV) contribution. For the contribution itself, use GetLeastContribution()
}
\examples{
\donttest{
nObjective <- 5 # the number of objectives
nPoint <- 10 # the number of points that will form the hypervolume
objective <- matrix(stats::runif(nObjective*nPoint), nrow = nObjective, ncol = nPoint)
GetHypervolume(objective,,"exact") # no reference supplied

reference <- rep(2,nObjective) # create a reference point at (2,2,2,2,2)
GetLeastContributor(objective,reference,"exact")
}
}
