% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_MT.R
\name{general_MT}
\alias{general_MT}
\title{General function to generate a unit space for a family of 
  Mahalanobis-Taguchi (MT) methods}
\usage{
general_MT(unit_space_data, calc_A, generates_transform_function,
  includes_transformed_data = FALSE)
}
\arguments{
\item{unit_space_data}{Matrix with n rows (samples) and p columns (variables).
Data to generate the unit space. All data should be 
continuous values and should not have missing values.}

\item{calc_A}{Function that returns A in a quadratic form x'Ax. \code{calc_A} 
takes the transformed data as an (only) argument.}

\item{generates_transform_function}{Function that takes \code{unit_space_data} 
as an (only) argument and returns a 
data transformation function. The data 
transformation function takes data as 
an (only) argument and returns the 
transformed data.}

\item{includes_transformed_data}{If \code{TRUE}, then the transformed data 
are included in a return object.}
}
\value{
A list containing the following components is returned.

\item{A}{q x q matrix calculated by \code{calc_A}.}
\item{calc_A}{Function passed by \code{calc_A}.}
\item{transforms_data}{Data transformation function generated from 
                        \code{generates_transform_function} based on 
                        \code{unit_space_data}.}
\item{distance}{Vector with length n. Distances from the unit space to each 
                 sample.}
\item{n}{The number of samples.}
\item{q}{The number of independent variables after the data transformation. 
          According to the data transoformation function, q may be equal to p.} 
\item{x}{If \code{includes_transformed_data} is \code{TRUE}, then the 
          transformed data are included.}
}
\description{
\code{general_MT} is a (higher-order) general function that generates a unit 
  space for a family of Mahalanobis-Taguchi (MT) methods. Each MT method can 
  be implemented by setting the parameters of this function appropriately.
}
\examples{
# 40 data for versicolor in the iris dataset                            
iris_versicolor <- iris[61:100, -5] 

# The following settings are same as the MT method.                          
unit_space <- general_MT(unit_space_data = iris_versicolor, 
                         generates_transform_function = 
                                            generates_normalization_function,
                         calc_A = function(x) solve(cor(x)),  
                         includes_transformed_data = TRUE)
                         
(unit_space$distance)

}
\seealso{
\code{\link{MT}}, \code{\link{MTA}} and \code{\link{RT}}
}

