% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pstate.R
\name{Pstate}
\alias{Pstate}
\title{Filtered state probabilities.}
\usage{
Pstate(object, theta, y)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}
or fit object of type \code{MSGARCH_MLE_FIT} created with \code{\link{fit.mle}} or \code{MSGARCH_BAY_FIT}
created with \code{\link{fit.bayes}}.}

\item{theta}{Vector (of size d) or matrix (of size M x d) of parameter estimates (not require when using a fit object).}

\item{y}{Vector (of size T) of observations (not require when using a fit object).}
}
\value{
Filtered state probabilities of class \code{MSGARCH_PSTATE} (array of size (T + 1) x M x K).
The class \code{MSGARCH_PSTATE} contains the \code{plot} method.
}
\description{
Method returning the filtered probabilities of the states.
}
\details{
If a matrix of parameter estimates is given, each parameter estimates is evaluated individually.
}
\examples{
# load data
data("sp500")
sp500 = sp500[1:1000]

# create model specification
spec = MSGARCH::create.spec() 

# fit the model on the data with ML estimation using DEoptim intialization
set.seed(123)
fit = MSGARCH::fit.mle(spec = spec, y = sp500, ctr = list(do.init = FALSE))
 
# compute the filtered state probabilities
Pstate  = MSGARCH::Pstate(object = fit)

plot(Pstate)
}

