#include "MSgarch.h"

//=========================================================================//
//=========================================================================//
//================================== GAS ==================================//
//=========================================================================//
//=========================================================================//
RCPP_MODULE(GAS){ 
  
  // GAS-norm-symmetric
  class_<GAS_norm_sym>("GAS_norm_sym")  
    .constructor()
    .field( "name",        &GAS_norm_sym ::name )
    .field( "theta0",      &GAS_norm_sym ::theta0 )
    .field( "Sigma0",      &GAS_norm_sym ::Sigma0 )
    .field( "label",       &GAS_norm_sym ::label )
    .field( "lower",       &GAS_norm_sym ::lower )
    .field( "upper",       &GAS_norm_sym ::upper )
    .field( "ineq_lb",     &GAS_norm_sym ::ineq_lb )
    .field( "ineq_ub",     &GAS_norm_sym ::ineq_ub )
    .field( "NbParams",    &GAS_norm_sym ::NbParams )
    .field( "NbParamsModel",&GAS_norm_sym ::NbParamsModel)
    .method( "f_sim",      &GAS_norm_sym ::f_sim )
    .method( "f_pdf",      &GAS_norm_sym ::f_pdf )
    .method( "f_pdf_its",  &GAS_norm_sym ::f_pdf_its )
    .method( "f_cdf",      &GAS_norm_sym ::f_cdf )
    .method( "f_cdf_its",  &GAS_norm_sym ::f_cdf_its )
    .method( "f_rnd",      &GAS_norm_sym ::f_rnd )
    .method( "calc_ht",    &GAS_norm_sym ::calc_ht )
    .method( "eval_model", &GAS_norm_sym ::eval_model )
    .method( "ineq_func",  &GAS_norm_sym ::ineq_func )
    .method( "f_unc_vol",  &GAS_norm_sym ::f_unc_vol)
  ;
  // GAS-std-symmetric
  class_<GAS_std_sym>("GAS_std_sym")  
    .constructor()
    .field( "name",        &GAS_std_sym ::name )
    .field( "theta0",      &GAS_std_sym ::theta0 )
    .field( "Sigma0",      &GAS_std_sym ::Sigma0 )
    .field( "label",       &GAS_std_sym ::label )
    .field( "lower",       &GAS_std_sym ::lower )
    .field( "upper",       &GAS_std_sym ::upper )
    .field( "ineq_lb",     &GAS_std_sym ::ineq_lb )
    .field( "ineq_ub",     &GAS_std_sym ::ineq_ub )
    .field( "NbParams",    &GAS_std_sym ::NbParams )
   	.field( "NbParamsModel",&GAS_std_sym ::NbParamsModel)
    .method( "f_sim",      &GAS_std_sym ::f_sim )
    .method( "f_pdf",      &GAS_std_sym ::f_pdf )
    .method( "f_pdf_its",  &GAS_std_sym ::f_pdf_its )
    .method( "f_cdf",      &GAS_std_sym ::f_cdf )
    .method( "f_cdf_its",  &GAS_std_sym ::f_cdf_its )
    .method( "f_rnd",      &GAS_std_sym ::f_rnd )
    .method( "calc_ht",    &GAS_std_sym ::calc_ht )
    .method( "eval_model", &GAS_std_sym ::eval_model )
    .method( "ineq_func",  &GAS_std_sym ::ineq_func )
    .method( "f_unc_vol",  &GAS_std_sym ::f_unc_vol)
  ;
  // GAS-ged-symmetric
  class_<GAS_ged_sym>("GAS_ged_sym")  
    .constructor()
    .field( "name",        &GAS_ged_sym ::name )
    .field( "theta0",      &GAS_ged_sym ::theta0 )
    .field( "Sigma0",      &GAS_ged_sym ::Sigma0 )
    .field( "label",       &GAS_ged_sym ::label )
    .field( "lower",       &GAS_ged_sym ::lower )
    .field( "upper",       &GAS_ged_sym ::upper )
    .field( "ineq_lb",     &GAS_ged_sym ::ineq_lb )
    .field( "ineq_ub",     &GAS_ged_sym ::ineq_ub )
    .field( "NbParams",    &GAS_ged_sym ::NbParams )
   	.field( "NbParamsModel",&GAS_ged_sym ::NbParamsModel)
    .method( "f_sim",      &GAS_ged_sym ::f_sim )
    .method( "f_pdf",      &GAS_ged_sym ::f_pdf )
    .method( "f_pdf_its",  &GAS_ged_sym ::f_pdf_its )
    .method( "f_cdf",      &GAS_ged_sym ::f_cdf )
    .method( "f_cdf_its",  &GAS_ged_sym ::f_cdf_its )
    .method( "f_rnd",      &GAS_ged_sym ::f_rnd )
    .method( "calc_ht",    &GAS_ged_sym ::calc_ht )
    .method( "eval_model", &GAS_ged_sym ::eval_model )
    .method( "ineq_func",  &GAS_ged_sym ::ineq_func )
    .method( "f_unc_vol",  &GAS_ged_sym ::f_unc_vol)
  ;
  
  
  
  // GAS-norm-skew
  class_<GAS_norm_skew>("GAS_norm_skew")  
    .constructor()
    .field( "name",        &GAS_norm_skew ::name )
    .field( "theta0",      &GAS_norm_skew ::theta0 )
    .field( "Sigma0",      &GAS_norm_skew ::Sigma0 )
    .field( "label",       &GAS_norm_skew ::label )
    .field( "lower",       &GAS_norm_skew ::lower )
    .field( "upper",       &GAS_norm_skew ::upper )
    .field( "ineq_lb",     &GAS_norm_skew ::ineq_lb )
    .field( "ineq_ub",     &GAS_norm_skew ::ineq_ub )
    .field( "NbParams",    &GAS_norm_skew ::NbParams )
    .field( "NbParamsModel",&GAS_norm_skew ::NbParamsModel)
    .method( "f_sim",      &GAS_norm_skew ::f_sim )
    .method( "f_pdf",      &GAS_norm_skew ::f_pdf )
    .method( "f_pdf_its",  &GAS_norm_skew ::f_pdf_its )
    .method( "f_cdf",      &GAS_norm_skew ::f_cdf )
    .method( "f_cdf_its",  &GAS_norm_skew ::f_cdf_its )
    .method( "f_rnd",      &GAS_norm_skew ::f_rnd )
    .method( "calc_ht",    &GAS_norm_skew ::calc_ht )
    .method( "eval_model", &GAS_norm_skew ::eval_model )
    .method( "ineq_func",  &GAS_norm_skew ::ineq_func )
    .method( "f_unc_vol",  &GAS_norm_skew ::f_unc_vol)
  ;
  // GAS-std-skew
  class_<GAS_std_skew>("GAS_std_skew")  
    .constructor()
    .field( "name",        &GAS_std_skew ::name )
    .field( "theta0",      &GAS_std_skew ::theta0 )
    .field( "Sigma0",      &GAS_std_skew ::Sigma0 )
    .field( "label",       &GAS_std_skew ::label )
    .field( "lower",       &GAS_std_skew ::lower )
    .field( "upper",       &GAS_std_skew ::upper )
    .field( "ineq_lb",     &GAS_std_skew ::ineq_lb )
    .field( "ineq_ub",     &GAS_std_skew ::ineq_ub )
    .field( "NbParams",    &GAS_std_skew ::NbParams )
   	.field( "NbParamsModel",&GAS_std_skew ::NbParamsModel)
    .method( "f_sim",      &GAS_std_skew ::f_sim )
    .method( "f_pdf",      &GAS_std_skew ::f_pdf )
    .method( "f_pdf_its",  &GAS_std_skew ::f_pdf_its )
    .method( "f_cdf",      &GAS_std_skew ::f_cdf )
    .method( "f_cdf_its",  &GAS_std_skew ::f_cdf_its )
    .method( "f_rnd",      &GAS_std_skew ::f_rnd )
    .method( "calc_ht",    &GAS_std_skew ::calc_ht )
    .method( "eval_model", &GAS_std_skew ::eval_model )
    .method( "ineq_func",  &GAS_std_skew ::ineq_func )
    .method( "f_unc_vol",  &GAS_std_skew ::f_unc_vol)
  ;
  // GAS-ged-skew
  class_<GAS_ged_skew>("GAS_ged_skew")  
    .constructor()
    .field( "name",        &GAS_ged_skew ::name )
    .field( "theta0",      &GAS_ged_skew ::theta0 )
    .field( "Sigma0",      &GAS_ged_skew ::Sigma0 )
    .field( "label",       &GAS_ged_skew ::label )
    .field( "lower",       &GAS_ged_skew ::lower )
    .field( "upper",       &GAS_ged_skew ::upper )
    .field( "ineq_lb",     &GAS_ged_skew ::ineq_lb )
    .field( "ineq_ub",     &GAS_ged_skew ::ineq_ub )
    .field( "NbParams",    &GAS_ged_skew ::NbParams )
   	.field( "NbParamsModel",&GAS_ged_skew ::NbParamsModel)
    .method( "f_sim",      &GAS_ged_skew ::f_sim )
    .method( "f_pdf",      &GAS_ged_skew ::f_pdf )
    .method( "f_pdf_its",  &GAS_ged_skew ::f_pdf_its )
    .method( "f_cdf",      &GAS_ged_skew ::f_cdf )
    .method( "f_cdf_its",  &GAS_ged_skew ::f_cdf_its )
    .method( "f_rnd",      &GAS_ged_skew ::f_rnd )
    .method( "calc_ht",    &GAS_ged_skew ::calc_ht )
    .method( "eval_model", &GAS_ged_skew ::eval_model )
    .method( "ineq_func",  &GAS_ged_skew ::ineq_func )
    .method( "f_unc_vol",  &GAS_ged_skew ::f_unc_vol)
  ;
}
