% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSG-package.R
\docType{data}
\name{ChinaLifeEdu}
\alias{ChinaLifeEdu}
\title{Life Expectancy and the Number of People with Higher Education in China
(2005)}
\format{A data frame with 31 observations on the following 2 variables.
  \describe{ \item{Life.Expectancy}{Life expectancy}
  \item{High.Edu.NO}{Number of people with higher education} }}
\source{
China Statistical Yearbook 2005. National Bureau of Statistics.
}
\description{
This data contains the life expectancy and number of people with higher
education in the 31 provinces and districts in China (2005).
}
\examples{
data(ChinaLifeEdu)
x = ChinaLifeEdu
plot(x, type = "n", xlim = range(x[, 1]), ylim = range(x[, 2]))
u = par("usr")
rect(u[1], u[3], u[2], u[4], col = "antiquewhite", border = "red")
library(KernSmooth)
est = bkde2D(x, apply(x, 2, dpik))
contour(est$x1, est$x2, est$fhat, nlevels = 15, col = "darkgreen", add = TRUE, 
    vfont = c("sans serif", "plain"))
}
