% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiMSE.R
\name{SimulateMOM}
\alias{SimulateMOM}
\alias{ProjectMOM}
\alias{multiMSE}
\title{Run a multi-fleet multi-stock Management Strategy Evaluation}
\usage{
SimulateMOM(MOM = MSEtool::Albacore_TwoFleet, parallel = TRUE, silent = FALSE)

ProjectMOM(
  multiHist = NULL,
  MPs = NA,
  parallel = FALSE,
  silent = FALSE,
  checkMPs = TRUE
)

multiMSE(
  MOM = MSEtool::Albacore_TwoFleet,
  MPs = list(list(c("AvC", "DCAC"), c("FMSYref", "curE"))),
  Hist = FALSE,
  silent = FALSE,
  parallel = TRUE,
  checkMPs = TRUE
)
}
\arguments{
\item{MOM}{A multi-fleet multi-stock operating model (class 'MOM')}

\item{parallel}{Logical. Should the MSE be run using parallel processing?}

\item{silent}{Should messages be printed out to the console?}

\item{multiHist}{An Historical Simulation object (class \code{multiHist})}

\item{MPs}{A matrix of methods (nstock x nfleet) (character string) of class MP}

\item{checkMPs}{Logical. Check if the specified MPs exist and can be run on \code{SimulatedData}?}

\item{Hist}{Should model stop after historical simulations? Returns a list
containing all historical data}
}
\value{
Functions return objects of class \code{MMSE} and \code{multiHist}
#' \itemize{
\item SimulateMOM - An object of class \code{multiHist}
\item ProjectMOM - An object of class \code{MMSE}
\item multiMSE - An object of class \code{MMSE}
}
}
\description{
Functions for running a multi-stock and/or multi-fleet Management
Strategy Evaluation (closed-loop simulation) for a specified operating model
}
\section{Functions}{
\itemize{
\item \code{SimulateMOM}: Simulate historical dynamics for multi-OM

\item \code{ProjectMOM}: Run Forward Projections for a \code{MOM} object

\item \code{multiMSE}: Run a multi-stock, multi-fleet MSE
}}

\author{
T. Carruthers and A. Hordyk
}
