% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeQuartetDist.R
\name{QDC}
\alias{QDC}
\title{Compute Quartet Distance Consensus tree from gene tree data}
\usage{
QDC(
  genetreedata,
  taxanames = NULL,
  method = fastme.bal,
  omit = FALSE,
  metric = FALSE
)
}
\arguments{
\item{genetreedata}{gene tree data that may be supplied in any of 3 forms: 
\enumerate{
\item a character string giving the name of a file containing gene trees in Newick,
\item a multiPhylo object containing gene trees, or
\item a resolved quartet table, such as produced by \code{quartetTableResolved}
}}

\item{taxanames}{if \code{genetreedata} is a file or a multiPhylo object, a vector of a subset
of the taxa names on the gene trees 
to be analyzed, if \code{NULL} all taxa on the first gene tree are used; if \code{genetreedata} 
is a quartet table, this argument is ignored and all taxa in the table are used}

\item{method}{a distance-based tree building function, such as \code{fastme.bal} or \code{nj}}

\item{omit}{\code{TRUE} ignores unresolved quartets; \code{FALSE} treats them as 1/3 of each resolution; 
ignored if \code{genetreedata} is supplied as a quartet table}

\item{metric}{if \code{FALSE} return topological tree; if \code{TRUE} return metric tree with
internal edge lengths estimated by \code{estimateEdgeLengths} with \code{lambda=0}, and terminal branches of length 1}
}
\value{
an unrooted tree of type phylo
}
\description{
Compute the Quartet Distance Consensus \insertCite{Rho19}{MSCquartets} estimate of an unrooted 
topological species tree from gene tree data.
}
\details{
This function is a wrapper which performs the steps of reading in a collection
of gene trees, tallying quartets, computing the quartet distance between taxa, building
a tree which consistently estimates the unrooted species tree topology under the MSC, and then possibly estimating edge
lengths using the "simpleML" method.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
stree=QDC(gtrees,tnames[1:6])
write.tree(stree)
plot(stree)
streeMetric=QDC(gtrees, tnames[1:6],metric=TRUE)
write.tree(streeMetric)
plot(streeMetric)

}
\references{
\insertRef{Rho19}{MSCquartets}
}
\seealso{
\code{\link{quartetTable}},
         \code{\link{quartetTableResolved}},
         \code{\link{quartetTableDominant}},
         \code{\link{quartetDist}},
         \code{\link{QDS}},
         \code{\link{WQDC}}, 
         \code{\link{WQDCrecursive}}
         \code{\link{estimateEdgeLengths}}
}
