% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NANUQ.R
\name{quartetNetworkDist}
\alias{quartetNetworkDist}
\title{Compute network quartet distance between taxa}
\usage{
quartetNetworkDist(pTable, alpha, beta)
}
\arguments{
\item{pTable}{a table of quartets and p-values, as computed by NANUQ, or
\code{quartetTreeTestInd} and \code{quartetStarTestInd}}

\item{alpha}{a scalar significance level for judging p-values \code{p_T3} indicating hybridization on quartet;
smaller value gives fewer hybridization decisions}

\item{beta}{a scalar significance level for judging p-values \code{p_star} indicating quartet star tree;
smaller value gives fewer resolved tree decisions}
}
\value{
a distance table
}
\description{
Produce network quartet distance table for the NANUQ algorithm, from a table of quartets and p-values, 
and specified levels of quartet hypothesis tests. The network quartet distance, which
is described more fully by \insertCite{ABR19;textual}{MSCquartets}, generalizes 
the quartet distance of \insertCite{Rho19;textual}{MSCquartets}.
}
\details{
In case of a triple of quartet counts with the two largest equal and the third slighltly smaller, 
along with \code{alpha} and \code{beta} leading to a star quartet being rejected and a tree not being rejected, 
this function chooses a resolved quartet topology uniformly at random from the two largest counts. This is the only 
stochastic element of the code, and its impact is usually negligable.
}
\examples{
pTable=NANUQ(system.file("extdata", "dataYeastRokas",package="MSCquartets"), alpha=.0001, 
       beta=.95,outfile = file.path(tempdir(), "NANUQdist"))
dist=quartetNetworkDist(pTable, alpha=.05, beta=.95)
dist

}
\references{
\insertRef{ABR19}{MSCquartets}

\insertRef{Rho19}{MSCquartets}
}
\seealso{
\code{\link{NANUQ}}, \code{\link{NANUQdist}}
}
