% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{mm}
\alias{mm}
\title{mm calculates the predicted Michaelis-Menton length-at-age}
\usage{
mm(p, ages)
}
\arguments{
\item{p}{is a vector the first three cells of which are a, b, c
for the mm curve.}

\item{ages}{is a vector of ages; could be a single number}
}
\value{
a vector of predicted lengths for a vector of ages in 'ages'
}
\description{
mm calculates length-at-age for the generalized 
    Michaelis-Menton curve. The equation being (a x ages)/(b + ages^c).
}
\examples{
 ages <- seq(0,20,1)    # sigma is ignored here
 pars <- c(a=23.0,b=1.0,c=1.0,sigma=1.0) # a, b, c, sigma
 plot1(ages,mm(pars,ages),xlab="Age",ylab="Length",lwd=2)
}
