% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproj_bbox.R
\name{reproj_bbox}
\alias{reproj_bbox}
\title{Reproject a bounding box}
\usage{
reproj_bbox(bbox, in_proj, out_proj, enlarge = TRUE)
}
\arguments{
\item{bbox}{The input bounding box (it can be a matrix obtained from \code{sp::bbox()},
or a numeric vector in the format (xmin, ymin, xmax, ymax)).}

\item{in_proj}{(\code{crs} | \code{character}) crs of the input projection,
or string coercible to it using \code{sf::st_crs()} (e.g., WKT or numeric
EPSG code)}

\item{out_proj}{\code{crs} \code{crs} of the output projection, or string coercible to
it using \code{sf::st_crs()} (e.g., WKT or numeric EPSG code)}

\item{enlarge}{`logical`` if TRUE, the reprojected bounding box is the
one which completely include the original one; if FALSE, it is simply the
one obtained by reprojecting the upper-left and the lower-right corners.}
}
\description{
Helper function used to reproject bounding boxes; setting the parameter
'enlarge' allows to choose if the new one would be the one which completely
includes the original extent in the output projection, or if is simply the
one obtained by reprojecting the upper-left and the lower-right corners.
}
\note{
License: GPL 3.0
}
\author{
Luigi Ranghetti, phD (2015)
}
