% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_process_bands.R
\name{MODIStsp_process_bands}
\alias{MODIStsp_process_bands}
\title{MODIStsp helper for processing original HDF layers}
\usage{
MODIStsp_process_bands(
  out_folder_mod,
  modislist,
  outproj_str,
  mod_proj_str,
  sens_sel,
  band,
  bandname,
  date_name,
  datatype,
  nodata_in,
  nodata_out,
  full_ext,
  bbox,
  scale_val,
  scale_factor,
  offset,
  out_format,
  outrep_file,
  compress,
  out_res_sel,
  out_res,
  resampling,
  nodata_change,
  gui,
  verbose,
  parallel
)
}
\arguments{
\item{out_folder_mod}{\code{character} Output folder for original HDF storage.
If \code{"$tempdir"} (default), a temporary directory is used.}

\item{modislist}{\verb{character array} List of MODIS images to be downloaded for
the selected date (as returned from \code{get_mod_filenames}). Can be a single
image, or a list of images in case different tiles are needed!}

\item{outproj_str}{\code{character} EPSG or WKT of output projection.}

\item{mod_proj_str}{\code{character} EPSG or WKT of MODIS projection.}

\item{sens_sel}{\code{character ["terra" | "aqua"]} Selected sensor.}

\item{band}{\code{numeric} band number corresponding to the HDF layer to be
processed}

\item{bandname}{\code{character} Name of the HDF layer to be processed.}

\item{date_name}{\code{character} Date of acquisition of the images to be
downloaded.}

\item{datatype}{\code{character} Datatype to the HDF layer to be processed.}

\item{nodata_in}{\code{numeric} Original nodata value to the HDF layer to be
processed.}

\item{nodata_out}{\code{numeric} Output nodata value to the HDF layer to be
processed.}

\item{full_ext}{\code{logical} If TRUE, process full tiles, if FALSE, process
bbox}

\item{bbox}{\code{numeric(4)} Output bounding box (xmin, ymin, xmax, ymax) in
out_proj coordinate system. Ignored if spatmeth == "tiles", Default: NULL}

\item{scale_val}{\code{logical} If TRUE,  scale and offset are applied to
original MODIS layers, and Spectral Indexes are saved as floating point. If
FALSE, no rescaling is done and Spectral Indexes are saved as integer, with a
10000 scaling factor.}

\item{scale_factor}{\code{numeric} Scale factor to be applied to the HDF layer
to be processed (Ignored if \code{scale_val} == FALSE).}

\item{offset}{\code{numeric} Offset to be applied to the HDF layer
to be processed (Ignored if \code{scale_val} == FALSE).}

\item{out_format}{\code{character ["ENVI" | "GTiff"]} Desired output format.}

\item{outrep_file}{\code{character} Full path of the file where results of the
processing are to be stored (created in \code{MODIStsp_process})}

\item{compress}{\code{character ["None" | "PACKBITS" | "LZW" | "DEFLATE"]}
Compression method for GTiff outputs (Ignored if \code{out_format == ENVI})}

\item{out_res_sel}{\verb{character ["Native", "User Defined}]. If "Native", the
outputs keep the original resolution of MODIS HDF images. Otherwise, the value
set in "out_res" is used.}

\item{out_res}{\code{float} Output resolution (in output projection measurement
unit). Ignored if out_res_sel == "Native".}

\item{resampling}{\verb{character ["near" | "bilinear" | "cubic" | "cubicspline", |lanczos"|, "average"|, "mode", |"max"|, |"min"|, |"q1"|, |"q3"|, |"sum"|]}
Resampling method to be used by \code{gdalwarp}.}

\item{nodata_change}{\code{logical} if TRUE, NoData values are set to the max value
of the datatype of the layer on the MODIStsp output rasters. NOTE: If multiple
nodata values are reported for a layer, all are reset to the new value.}

\item{gui}{\code{logical} if TRUE: the GUI is opened before processing. If FALSE:
processing parameters are retrieved from the provided \code{opts_file}
argument), Default: TRUE}

\item{verbose}{\code{logical} If FALSE, suppress processing messages, Default: TRUE}

\item{parallel}{\code{logical} If TRUE, the function is run using parallel
processing, to speed-up the computation for large rasters (with a maximum
of 8 cores).
The number of cores is automatically determined; specifying it is also
possible (e.g. \code{parallel = 4}). In this case, more than 8 cores can be
specified. If FALSE (default), single core processing is used.}
}
\value{
The function is called for its side effects
}
\description{
Internal function used to perform the required spatial
processing on MODIS original hdf layers (reprojection, resizing, resampling,
mosaicing, computation of scaling factors). The function is based on the
use of \code{gdal} routines.
}
\author{
Lorenzo Busetto, phD (2014-2017)

Luigi Ranghetti, phD (2015)
}
