% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCollection.R
\name{getCollection}
\alias{getCollection}
\title{Get Available Collections of MODIS Product(s)}
\usage{
getCollection(product, collection = NULL, newest = TRUE,
  forceCheck = FALSE, as = "character", quiet = TRUE, ...)
}
\arguments{
\item{product}{\code{character}. MODIS grid product to check for existing 
collections, see \code{\link{getProduct}}.}

\item{collection}{\code{character} or \code{integer}. If provided, the 
function only checks if the specified collection exists and returns the 
collection number formatted based on the \code{as} parameter or \code{FALSE} 
if it doesn't exists. The check is performed on the primary data source, 
'LP DAAC' \url{https://lpdaac.usgs.gov/}.}

\item{newest}{\code{logical}. If \code{TRUE} (default), return only the 
newest collection, else return all available collections.}

\item{forceCheck}{\code{logical}, defaults to \code{FALSE}. If \code{TRUE}, 
connect to the 'LP DAAC' FTP server and get available collections, of which 
an updated version is permanently stored in 
\code{MODIS:::combineOptions()$auxPath}.}

\item{as}{\code{character}, defaults to \code{'character'} which returns the 
typical 3-digit collection number (i.e., \code{"005"}). \code{as = 'numeric'} 
returns the result as \code{numeric} (i.e., \code{5}).}

\item{quiet}{\code{logical}, defaults to \code{TRUE}.}

\item{...}{Additional arguments passed to \code{MODIS:::combineOptions}.}
}
\value{
A 3-digit \code{character} or \code{numeric} object (depending on 'as') or, 
if \code{length(product) > 1}, a \code{list} of such objects with each slot 
corresponding to the collection available for a certain product. 
Additionally, a text file in a hidden folder located in 
\code{getOption("MODIS_localArcPath")} as database for future calls. If 
'collection' is provided, only the (formatted) collection (or \code{FALSE} if 
it could not be found) is returned.
}
\description{
Checks and retrieves available MODIS collection(s) for a given product.
}
\examples{
\dontrun{

# update or get collections for MOD11C3 and MYD11C3
getCollection(product="M.D11C3")
getCollection(product="M.D11C3",newest=FALSE)

getCollection(product="M.D11C3",collection=3)
getCollection(product="M.D11C3",collection=41)
getCollection(product="M.D11C3",collection="041")
getCollection(product="M.D11C3",forceCheck=TRUE)
}

}
\author{
Matteo Mattiuzzi
}
\seealso{
\code{\link{getProduct}}.
}

