% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMotifSet.R
\name{addMotifSet}
\alias{addMotifSet}
\title{\code{addMotifSet}}
\usage{
addMotifSet(
  SampleTileObj,
  motifPWMs,
  w = 7,
  returnSTM = TRUE,
  motifSetName = "Motifs"
)
}
\arguments{
\item{SampleTileObj}{A SummarizedExperiment, specifically the output of
getSampleTileMatrix}

\item{motifPWMs}{A pwms object for the motif database. Either PFMatrix,
PFMatrixList, PWMatrix, or PWMatrixList}

\item{w}{Parameter for motifmatchr controlling size in basepairs of window for filtration.
Default is 7.}

\item{returnSTM}{If TRUE, return the modified SampleTileObj with motif set
added to metadata (default). If FALSE, return just the motifs from motifmatchr.}

\item{motifSetName}{Name to give motifList in the SampleTileObj's metadata
if `returnSTM=TRUE`. Default is 'Motifs'.}
}
\value{
the modified SampleTileObj with motifs added to the metadata
}
\description{
\code{addMotifSet} Identify motifs within your peakset.
}
\examples{
\dontrun{
# load a curated motif set from library(chromVARmotifs)
# included with ArchR installation
data(human_pwms_v2)
SE_with_motifs <- addMotifSet(
  SampleTileObj,
  motifPWMs = human_pwms_v2,
  returnSTM = TRUE, motifSetName = "Motifs", w = 7
)
}

}
