% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{listToMatrix}
\alias{listToMatrix}
\title{Obtain a sparse matrix of the coefficients of the path}
\usage{
listToMatrix(x, row = c("covariates", "lambda"))
}
\arguments{
\item{x}{\code{\link{MLGL}} object}

\item{row}{"lambda" or "covariates". If row="covariates", each row of the output matrix represents a covariate else if row="lambda", it represents a value of lambda.}
}
\value{
a sparse matrix containing the estimated coefficients for different lambdas
}
\description{
Obtain a sparse matrix of the coefficients of the path
}
\details{
This function can be used with a \code{\link{MLGL}} object to obtain a matrix with all estimated coefficients for the p original variables.
In case of overlapping groups, coefficients from repeated variables are summed.
}
\examples{
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
# Apply MLGL method
res <- MLGL(X, y)
# Convert output in sparse matrix format
beta <- listToMatrix(res)
}
\seealso{
\link{MLGL}, \link{overlapgglasso}
}
