% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_over_epoch.R
\name{aggregate_for_orientation}
\alias{aggregate_for_orientation}
\title{Aggregate over epoch to get estimated accelerometer orientation.}
\usage{
aggregate_for_orientation(
  df,
  epoch,
  estimation_window = 2,
  unit = "deg",
  st = NULL
)
}
\arguments{
\item{df}{dataframe. Input accelerometer data in mhealth format. First column
should be timestamps in POSIXt format.}

\item{epoch}{string. Any format that is acceptable by argument \code{breaks}
in method \code{\link[base]{cut.POSIXt}}.For example, "1 sec", "1 min", "5
secs", "10 mins".}

\item{estimation_window}{number. Duration in seconds to be used to estimate
orientation within each epoch. Default is 2 (seconds), as suggested by
\href{https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=1241424}{Mizell,
2003}.}

\item{unit}{string. The unit of orientation angles. Can be "deg" (degree) or
"rad" (radian). Default is "deg".}

\item{st}{character or POSIXct timestamp. An optional start time you can set to
force the epochs generated by referencing this start time. If it is NULL, the
function will use the first timestamp in the timestamp column as start time to
generate epochs. This is useful when you are processing a stream of data and
want to use a common start time for segmenting data. Default is NULL.}
}
\value{
dataframe. The returned dataframe will have the same format as input
  dataframe.
}
\description{
\code{aggregate_for_orientation} returns a dataframe with accelerometer
orientations estimated by
\href{https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=1241424}{Mizell,
2003} over each epoch (see \code{\link{compute_orientation}}). The epoch
start time will be used as timestamp in the first column.
}
\details{
This function accepts a dataframe (in mhealth accelerometer data format) and
computes the estimated acclerometer orientations (in x, y, and z angles) over
each fixed epoch. The returned dataframe will have the same format as input
dataframe, including four columns, and have the same datetime format as input
dataframe in the timestamp column. The orientation estimation method used in
the function is based on
\href{https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=1241424}{Mizell,
2003}.
}
\note{
If \code{epoch} argument is not provided or is \code{NULL}, the
  function will treat the input dataframe as a single epoch.

  If the number of samples in an epoch is less than 90%, the output
  would be NaN (invalid) for this epoch.
}
\section{How is it used in mims-unit algorithm?}{
 This function is used in
  mims-unit algorithm after extrapolation (\code{\link{extrapolate}}). The
  extrapolated signal will be estimated to get orientation angles using this
  function.
}

\examples{
  # Use first 20000 rows from sample input data
  df = sample_raw_accel_data[1:20000,]
  head(df)

  # set epoch to 1 minute and unit to degree
  # last epoch does not have enough samples to estimate orientation angles.
  aggregate_for_orientation(df, epoch='1 min', unit='deg')

  # set epoch to 2 minute and unit to radian
  # last epoch does not have enough samples to estimate orientation angles.
  aggregate_for_orientation(df, epoch='2 min', unit='rad')

  # epoch set to 2 minute, and st set to be 1 minute before the start time of the data
  # so the first segment will only include data for 1 minute, therefore the resulted
  # aggregated value for the first segment will be -1 (invalid) because the
  # samples are not enough. And the second segment starts from 11:01:00, instead
  # of 11:02:00 as shown in prior example,
  aggregate_for_orientation(df, epoch = '2 min', unit='rad', st=df[1,1] - 60)

}
\seealso{
\code{\link{aggregate_for_mims}} for aggregating to get integrated
  values for each axis for each epoch.

Other aggregate functions: 
\code{\link{aggregate_for_mims}()}
}
\concept{aggregate functions}
