% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_mhealth_csv_chunked}
\alias{import_mhealth_csv_chunked}
\title{Import large raw multi-channel accelerometer data stored in mHealth Specification
in chunks.}
\usage{
import_mhealth_csv_chunked(filepath, chunk_samples = 180000)
}
\arguments{
\item{filepath}{string. The filepath of the input data.}

\item{chunk_samples}{number. The number of samples in each chunk. Default is
180000, which is half hour data for 100 Hz sampling rate.}
}
\value{
list. The list contains two items. The first item is a generator
  function that each time it is called, it will
  return a dataframe with at most \code{chunk_samples} samples of imported data.
  The third item is a \code{close_connection} function which you can call at
  any moment to close the file loading.
}
\description{
\code{import_mhealth_csv_chunked} imports the raw multi-channel accelerometer
  data stored in mHealth Specification in chunks.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a File IO
  function that is used to import data stored in mHealth Specification during
  algorithm validation.
}

\examples{
  default_ops = options()
  options(digits.secs=3)

  # Use the mhealth csv file shipped with the package
  filepath = system.file('extdata', 'mhealth.csv', package='MIMSunit')

  # Example 1
  # Load chunks every 1000 samples
  results = import_mhealth_csv_chunked(filepath, chunk_samples=100)
  next_chunk = results[[1]]
  close_connection = results[[2]]
  # Check data as chunks, you can see chunk time is shifting forward at each iteration.
  n = 1
  repeat {
    df = next_chunk()
    if (nrow(df) > 0) {
      print(paste('chunk', n))
      print(paste("df:", df[1, 1], '-', df[nrow(df),1]))
      n = n + 1
    } else {
      break
    }
  }

  # Close connection after reading all the data
  close_connection()

  # Example 2: close loading early
  results = import_mhealth_csv_chunked(filepath, chunk_samples=1000)
  next_chunk = results[[1]]
  close_connection = results[[2]]
  # Check data as chunks, you can see chunk time is shifting forward at each iteration.
  n = 1
  repeat {
    df = next_chunk()
    if (nrow(df) > 0) {
      print(paste('chunk', n))
      print(paste("df:", df[1, 1], '-', df[nrow(df),1]))
      n = n + 1
      close_connection()
    }
    else {
      break
    }
  }

 # Restore default options
 options(default_ops)
}
\seealso{
Other File I/O functions: 
\code{\link{export_to_actilife}()},
\code{\link{import_actigraph_count_csv}()},
\code{\link{import_actigraph_csv_chunked}()},
\code{\link{import_actigraph_csv}()},
\code{\link{import_actigraph_meta}()},
\code{\link{import_activpal3_csv}()},
\code{\link{import_enmo_csv}()},
\code{\link{import_mhealth_csv}()}
}
\concept{File I/O functions}
