# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Get the MIDAS score
#'
#' @param input A data.frame with columns src (source, int), dst (destination, int) & times (timestamp of the edge, int) representing transaction edges
#' @param rows Number of rows/hash functions. Default is 2
#' @param buckets Number of buckets. Default is 769
#' @param alpha Temporal Decay Factor. Only used when 'MIDAS-R' is used. Default is 0.6
#' @param norelations Run 'MIDAS' instead of 'MIDAS-R'. Default is False
#' @param undirected If graph is undirected. Default is False
#' @return NumericVector of MIDAS-Scores
#' @export
getMIDASScore <- function(input, rows = 2L, buckets = 769L, alpha = .6, norelations = FALSE, undirected = FALSE) {
    .Call(`_MIDASwrappeR_getMIDASScore`, input, rows, buckets, alpha, norelations, undirected)
}

