% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhqol_utilities_to_states.R
\name{mhqol_utilities_to_states}
\alias{mhqol_utilities_to_states}
\title{Provides the states of the MHQoL based on the utilities provided (as described in the valueset)}
\usage{
mhqol_utilities_to_states(
  utilities,
  country = "Netherlands",
  ignore_invalid = FALSE,
  ignore_NA = FALSE,
  retain_old_variables = TRUE)
}
\arguments{
\item{utilities}{A dataframe, numeric vector, or list containing the utilities of the MHQoL.}

\item{country}{The country for which the utilities should be calculated. For now the only option is "Netherlands".}

\item{ignore_invalid}{If TRUE, the function will ignore missing utilities and continue processing.}

\item{ignore_NA}{If TRUE, the function will ignore NA values in the input data.}

\item{retain_old_variables}{If TRUE, the function will retain the old variables in the output.}
}
\value{
A dataframe containing the states of the MHQoL based on the utilities provided.
}
\description{
This function provides the states of the MHQoL based on the utilities provided (as described in the valueset).
}
\examples{
# Example usage of the mhqol_utilities_to_states function
# Get the states based on a numeric vector, not all states are present
mhqol_utilities_to_states(
  utilities = c(IN = -0.018, DA = -0.021, PH = -0.064, FU = -0.106),
  ignore_invalid = TRUE
)

# Get the states based on a dataframe
mhqol_utilities_to_states(
  utilities = data.frame(
    SI = -0.137,
    IN = -0.184,
    MO = -0.063,
    RE = -0.172,
    DA = -0.021,
    PH = -0.243,
    FU = -0.170
    )
)
}
\keyword{MHQoL}
\keyword{States}
\keyword{utilities}
