% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script.R
\name{probabilitiesMatrix}
\alias{probabilitiesMatrix}
\title{Probability matrix calculation.
Rows represent arriving probabilities at state i
and columns represent the same for state j}
\usage{
probabilitiesMatrix(
  i,
  j,
  m = c(0.2, 0.3),
  lambda = c(1, 2),
  tmax = 12,
  nmax = 5
)
}
\arguments{
\item{i}{MC i-th state}

\item{j}{MC j-th state}

\item{m}{distribution parameters vector of sojourn times
in alternating environment states}

\item{lambda}{Poisson flow intensity vector}

\item{tmax}{upper integration limit}

\item{nmax}{limitation for number of arriving claims}
}
\value{
matrix with \code{nmax} rows and columns
}
\description{
Probability matrix calculation.
Rows represent arriving probabilities at state i
and columns represent the same for state j
}
