% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bin}
\alias{bin}
\title{Fast binning of numeric vector into equidistant bins}
\usage{
bin(x, width, origin = 0, missinglast = FALSE)
}
\arguments{
\item{x}{A matrix of regressor variables. Must have the same number of rows as the length of y.}

\item{width}{The width of the bins}

\item{origin}{The starting point for the bins. Any number smaller than origin will be disregarded}

\item{missinglast}{Boolean. Should the missing observations be added as a separate element at the end of the returned count vector.}
}
\value{
An list with elements counts (the frequencies), origin (the origin), width (the width), missing (the number of missings), and last_bin_is_missing (boolean) telling whether the missinglast is true or not.
}
\description{
Fast binning of numeric vector into equidistant bins
}
\details{
Missing values (NA, Inf, NaN) are added at the end of the vector as the last bin returned if missinglast is set to TRUE
}
\examples{

set.seed(1)
x <- sample(10, 20, replace = TRUE)
bin(x, 15)

}
\author{
Hadley Wickham (from SO: https://stackoverflow.com/questions/13661065/superimpose-histogram-fits-in-one-plot-ggplot) - adapted here by Claus Ekstrøm <claus@rprimer.dk>
}
