% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classDefintions.R
\docType{class}
\name{bspline_basis-class}
\alias{bspline_basis-class}
\alias{bspline_basis}
\title{b-spline basis}
\description{
A s4 class that represents a b-spline basis \eqn{\{B_{i,p}(x)\}_{i=-p}^{k}} on the interval \eqn{[t_0,t_{k+1}]},
where \eqn{B_{i,p}(x)} is defined as
\deqn{B_{i,0}(x) = \left\{
  \begin{aligned}
  &I_{(t_i,t_{i+1}]}(x), & i = 0,1,\dots,k\\
  &0, &i<0\ or\ i>k
  \end{aligned}
  \right.}
 \deqn{B_{i,r}(x) = \frac{x - t_{i}}{t_{i+r}-t_{i}} B_{i,r-1}(x) + \frac{t_{i+r+1} - x}
    {t_{i+r+1} - t_{i+1}}B_{i+1,r-1}(x)}
      For all the discontinuity points of \eqn{B_{i,r}} (\eqn{r>0}) in the interval \eqn{(t_0,t_k)},
      let the value equals its limit, which means
 \deqn{B_{i,r}(x) = \lim_{t\to x} B_{i,r}(t)}
}
\section{Slots}{

\describe{
\item{\code{Boundary.knots}}{boundary of the domain of the splines (start and end), which is \eqn{t_0} and \eqn{t_{k+1}}.
Default is \eqn{[0,1]}. See \code{Boundary.knots} in \code{\link[splines]{bs}}.}

\item{\code{knots}}{knots of the splines, which is \eqn{(t_1,\dots,t_k)},
equally spaced sequence is chosen by the function automatically with equal space
(\eqn{t_j = t_0 + j\cdot\frac{t_{k+1}-t_0}{k+1}}) when not assigned.
See \code{knots} in \code{\link[splines]{bs}}.}

\item{\code{intercept}}{Whether an intercept is included in the basis,
default value is TRUE, and must be TRUE. See \code{intercept} \code{\link[splines]{bs}}.}

\item{\code{df}}{degree of freedom of the basis, which is the number of the splines, equal to \eqn{p+k+1}.
By default \eqn{k = 0}, and \code{df} \eqn{= p+1}. See \code{df} \code{\link[splines]{bs}}.}

\item{\code{degree}}{degree of the splines, which is the degree of piecewise polynomials \eqn{p}, default value is 3.
See \code{degree} in \code{\link[splines]{bs}}.}
}}

\examples{
bsb = bspline_basis(
            Boundary.knots = c(0,24),
            intercept      = TRUE,
            df             = NULL,
            degree         = 3
)
}
\author{
Heyang Ji
}
