% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{dmap.check}
\alias{dmap.check}
\title{Reorders a distance map by a new marker order.}
\usage{
dmap.check(distmap, newrank)
}
\arguments{
\item{distmap}{A symmetric matrix of pairwise inter-marker distances.}

\item{newrank}{A vector of scalars giving the new rank of each marker, markers 
should appear in the same order as in the distmap.}
}
\value{
Matrix of pairwise inter-marker distances.
}
\description{
Reorders a distance map by a new marker order.
}
\details{
The rows and columns in distmap are reordered such that if entry i in \code{newrank} 
has value j then row j and column j in the new matrix are row i and column i 
from distmap.
}
\examples{
s<-matrix(1:25,nrow=5)
s<-0.5*(s+t(s))
rank<-c(1,3,4,2,5)
dmap.check(s,rank)
}
