% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_gain.R
\name{ComputeMaxInfoGainsDiscrete}
\alias{ComputeMaxInfoGainsDiscrete}
\title{Max information gains (discrete)}
\usage{
ComputeMaxInfoGainsDiscrete(
  data,
  decision = NULL,
  dimensions = 1,
  pc.xi = 0.25,
  return.tuples = FALSE,
  return.min = FALSE,
  interesting.vars = vector(mode = "integer"),
  require.all.vars = FALSE
)
}
\arguments{
\item{data}{input data where columns are variables and rows are observations (all discrete with the same number of categories)}

\item{decision}{decision variable as a binary sequence of length equal to number of observations}

\item{dimensions}{number of dimensions (a positive integer; 5 max)}

\item{pc.xi}{parameter xi used to compute pseudocounts (the default is recommended not to be changed)}

\item{return.tuples}{whether to return tuples where max IG was observed (one tuple per variable) - not supported with CUDA nor in 1D}

\item{return.min}{whether to return min instead of max (per tuple) - not supported with CUDA}

\item{interesting.vars}{variables for which to check the IGs (none = all) - not supported with CUDA}

\item{require.all.vars}{boolean whether to require tuple to consist of only interesting.vars}
}
\value{
A \code{\link{data.frame}} with the following columns:
 \itemize{
   \item \code{IG} -- max information gain (of each variable)
   \item \code{Tuple.1, Tuple.2, ...} -- corresponding tuple (up to \code{dimensions} columns, available only when \code{return.tuples == T})
   \item \code{Discretization.nr} -- always 1 (for compatibility with the non-discrete function; available only when \code{return.tuples == T})
 }

 Additionally attribute named \code{run.params} with run parameters is set on the result.
}
\description{
Max information gains (discrete)
}
\details{
If \code{decision} is omitted, this function calculates either the variable entropy
(in 1D) or mutual information (in higher dimensions).
Translate "IG" respectively to entropy or mutual information in the
rest of this function's description.
}
\examples{
\donttest{
ComputeMaxInfoGainsDiscrete(madelon$data > 500, madelon$decision, dimensions = 2)
}
}
