% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCplot.R
\name{MCMCplot}
\alias{MCMCplot}
\title{Caterpillar plots of posterior distributions from MCMC output}
\usage{
MCMCplot(
  object,
  object2 = NULL,
  params = "all",
  HPD = FALSE,
  ci = c(50, 95),
  excl = NULL,
  ISB = TRUE,
  exact = TRUE,
  ref = 0,
  ref_ovl = FALSE,
  col = "black",
  col2 = "red",
  offset = 0.1,
  rank = FALSE,
  horiz = TRUE,
  xlim,
  ylim,
  xlab,
  ylab,
  main,
  labels,
  guide_lines = FALSE,
  guide_axis = TRUE,
  sz_labels = 1.2,
  sz_med = 1.5,
  sz_thick = 5,
  sz_thin = 2,
  sz_ax = 3,
  sz_ax_txt = 1.3,
  sz_tick_txt = 1.2,
  sz_main_txt = 1.2,
  pos_tick,
  mar = c(5.1, 4.1, 4.1, 2.1)
)
}
\arguments{
\item{object}{Object containing MCMC output. See DETAILS below.}

\item{object2}{Optional second object containing MCMC output. If specified, parameter estimates from each model will be displayed in a paired manner. Parameter names for \code{'object'} and \code{'object2'} must be identical. See DETAILS below.}

\item{params}{Character string (or vector of character strings) denoting parameters to be plotted.

Default \code{'all'} plots posteriors for all parameters. See VALUE below.}

\item{HPD}{Logical specifying whether to calculate equal-tailed credible intervals (\code{HPD = FALSE}) or highest posterior density intervals (\code{HPD = TRUE}) for the selected parameters. Default is \code{HPD = FALSE}.}

\item{ci}{Numeric vector of length 2, where each element is (0,100] and represents the width of an equal-tailed (\code{HPD = FALSE}) or highest posterior density (\code{HPD = TRUE}) credible interval. The first element of this vector corresponds to the thicker (narrower) credible interval displayed on the plot (default is 0.5) and the second element of this vector corresponds to the thinner (wider) credible interval (default is 0.95). The first credible interval width (\code{ci[1]}) must be less than or equal to the width of the second credible interval (\code{ci[2]}).}

\item{excl}{Character string (or vector of character strings) denoting parameters to exclude. Used in conjunction with \code{params} argument to select parameters of interest.}

\item{ISB}{Ignore Square Brackets (ISB). Logical specifying whether square brackets should be ignored in the \code{params} and \code{excl} arguments. If \code{TRUE}, square brackets are ignored. If \code{FALSE}, square brackets are not ignored.  This allows partial names to be used when specifying parameters of interest. Use \code{exact} argument to specify whether input from \code{params} and \code{excl} arguments should be matched exactly.}

\item{exact}{Logical specifying whether input from \code{params} and \code{excl} arguments should be matched exactly (after ignoring square brackets if \code{ISB = FALSE}). If \code{TRUE}, input from \code{params} and \code{excl} are matched exactly (after taking \code{ISB} argument into account). If \code{FALSE}, input from \code{params} and \code{excl} are matched using regular expression format (after taking \code{ISB} argument into account).}

\item{ref}{Value indicating where vertical reference line should be created and what value to use a reference for caterpillar median coloration.

Default is \code{ref = 0}.

Argument \code{NULL} will plot no reference line.}

\item{ref_ovl}{Logical specifying whether the style/color of plotted median dots and CI should be changed based on whether the specified credible intervals (50 \% and 95 \% by default) overlap the reference line. See DETAILS for more information.}

\item{col}{Character string (or vector of character strings) specifying which color to render estimates on plot. When \code{ref_ovl = TRUE}, this argument has no effect and colors plotted will be based on the credible intervals and reference line. Number of specified colors must equal the number of specified parameters or one.}

\item{col2}{Character string (or vector of character strings) specifying which color to render estimates on plot for \code{object2} (if specified). Number of specified colors must equal the number of specified parameters or one. Red by default.}

\item{offset}{Value indicating how much to offset plotted posteriors when \code{object2} is specified (i.e., control the amount of space between the two  plotted posteriors for each parameter). The distance from one set of parameters to another corresponds to a value of 1.}

\item{rank}{Logical specifying whether output should be ranked. If \code{TRUE} posteriors will be ranked in decreasing order (based on specified measure of centrality) from top down.}

\item{horiz}{Logical specifying orientation of plot. If \code{TRUE} posteriors will be plotted running horizontally (parallel to the x-axis). If \code{FALSE} posteriors will be plotted running vertically (perpendicular to the x-axis).}

\item{xlim}{Numerical vector of length 2, indicating range of x-axis. Only applicable if \code{horiz = TRUE}.}

\item{ylim}{Numerical vector of length 2, indicating range of y-axis. Only applicable if \code{horiz = FALSE}.}

\item{xlab}{Character string labeling x-axis. Only applicable if \code{horiz = TRUE}.

Default label is 'Parameter Estimate'. Option \code{NULL} will return plot with no label on x-axis.}

\item{ylab}{Character string labeling y-axis. Only applicable if \code{horiz = FALSE}.

Default label is 'Parameter Estimate'. Option \code{NULL} will return plot with no label on y-axis.}

\item{main}{Character string indicating title of plot.}

\item{labels}{Character string (or vector of character strings if plotting > 1 parameter) labeling parameter estimates along y-axis (if \code{horiz = FALSE}) or x-axis (if \code{horiz = TRUE}).

Default option will use parameter names from \code{object}.

Option \code{NULL} will return plot with no labels on axis.}

\item{guide_lines}{Logical specifying whether to plot reference lines for each parameter in order to better visualize which parameter names correspond to each posterior.}

\item{guide_axis}{Logical specifying whether a second axis should be plotted (x-axis if \code{HORIZ = TRUE}, y-axis if \code{HORIZ = FALSE}) to help interpret values on plot.}

\item{sz_labels}{Number specifying size of text for parameter labels on axis.}

\item{sz_med}{Number specifying size of points represents posterior medians.}

\item{sz_thick}{Number specifying thickness of 50 percent CI line (thicker line).}

\item{sz_thin}{Number specifying thickness of 95 percent CI line (thinner line).}

\item{sz_ax}{Number specifying thickness of axis and ticks.}

\item{sz_ax_txt}{Number specifying size of text for axis label.}

\item{sz_tick_txt}{Number specifying size of text for tick labels on axis.}

\item{sz_main_txt}{Number specifying size of text for main title.}

\item{pos_tick}{Numeric vector specifying where ticks on axis should be placed.}

\item{mar}{Numerical vector of length 4 specifying plot margins - (BOTTOM, LEFT, TOP, RIGHT). Changes to the margin should be made within the function rather than using the \code{par} call.

Default is c(5.1, 4.1, 4.1, 2.1) - the R plot default.}
}
\description{
Visualize posterior distributions from MCMC output for specific parameters of interest using caterpillar plots. Color of median dot represents the overlap of the posterior distribution with 0 (or other specified value).
}
\section{Details}{

Points represent posterior medians. Parameters where the smaller specified credible intervals (first value in vector provided to \code{ci} argument; 50\% by default) overlap 0 (or other value specified by the \code{ref} argument) are indicated by 'open' circles and a lighter color than that specified (e.g., gray will be displayed with the default black is specified for \code{col}). Parameters where the specific smaller credible intervals DO NOT overlap 0 (or other specified value) AND the larger specified credible intervals (second value in vector provided to \code{ci} argument; 95\% by default) DO overlap 0 (or other specified value) are indicated by 'closed' circles and a lighter color that that specified. Parameters where the larger specified credible intervals DO NOT overlap 0 (or other specified value) are indicated by 'closed' circles and the color specified (black by default). Thick lines represent the smaller specified credible intervals percent credible intervals (50\% by default) while thin lines represent the larger specified credible intervals (95 \% by default). \code{ref_ovl = TRUE} can be used to enable this feature. When two model objects are supplied to the function (with \code{object} and \code{object2}) and no argument is supplied to \code{col} or \code{col2}, light red lines can be interpreted as analogous to gray lines. When \code{ref_ovl = TRUE} and a color (or colors) other than the default are specified (with the \code{col} and \code{col2} arguments) lighter versions of the color specified are used in black of the light gray and/or light red lines.

When \code{object2} is specified, paired caterpillar plots of each parameter are produced. For this reason, parameter names of \code{object} and \code{object2} specified with the \code{params} argument must be identical (to be used for comparing posterior estimates of similar models). \code{col} and \code{col2} arguments can be specified to change the color of output from \code{object} and \code{object2}, respectively. By default, output from \code{object} is plotted in black and \code{object2} is plotted in red. The \code{ref_ovl} argument can also be specified.

\code{object} argument can be a \code{stanfit} object (\code{rstan} package), a \code{CmdStanMCMC} object (\code{cmdstanr} package), a \code{stanreg} object (\code{rstanarm} package), a \code{brmsfit} object (\code{brms} package), an \code{mcmc.list} object (\code{coda} and \code{rjags} packages), \code{mcmc} object (\code{coda} and \code{nimble} packages), \code{list} object (\code{nimble} package), an \code{R2jags} model object (\code{R2jags} package), a \code{jagsUI} model object (\code{jagsUI} package), or a matrix containing MCMC chains (each column representing MCMC output for a single parameter, rows representing iterations in the chain). The function automatically detects the object type and proceeds accordingly.
}

\section{Notes}{


When specifying \code{rank = TRUE} and specifying labels for \code{labels}, labels will be applied to parameters before they are ranked.

Thanks to Cinner et al. 2016, whose Fig. 1 inspired this plot.
}

\section{References}{


Cinner, J. E., C. Huchery, M. A. MacNeil, N. A. J. Graham, T. R. McClanahan, J. Maina, E. Maire, J. N. Kittinger, C. C. Hicks, C. Mora, E. H. Allison, S. D'Agata, A. Hoey, D. A. Feary, L. Crowder, I. D. Williams, M. Kulbicki, L. Vigliola, L. Wantiez, G. Edgar, R. D. Stuart-Smith, S. A. Sandin, A. L. Green, M. J. Hardt, M. Beger, A. Friedlander, S. J. Campbell, K. E. Holmes, S. K. Wilson, E. Brokovich, A. J. Brooks, J. J. Cruz-Motta, D. J. Booth, P. Chabanet, C. Gough, M. Tupper, S. C. A. Ferse, U. R. Sumaila, and D. Mouillot. 2016. Bright spots among the world's coral reefs. Nature 535:416-419.
}

\examples{
#Load data
data(MCMC_data)

#Plot MCMC output
MCMCplot(MCMC_data, labels = NULL)

#Just 'beta' parameters
MCMCplot(MCMC_data, params = 'beta')

#Just 'beta' parameters using highest posterior density intervals
MCMCplot(MCMC_data, params = 'beta', HPD = TRUE)
#Just 'beta[1]', 'beta[4]', and 'alpha[3]'
MCMCplot(MCMC_data, params = c('beta[1]', 'beta[4]', 'alpha[3]'), ISB = FALSE, exact = TRUE)

#Just 'beta[1]', 'beta[4]', and 'alpha[3]' and change the credible interval widths
MCMCplot(MCMC_data, ci = c(50, 89), params = c('beta[1]', 'beta[4]', 'alpha[3]'), 
  ISB = FALSE, exact = TRUE)

#Rank parameters by posterior mean
MCMCplot(MCMC_data, params = 'beta', rank = TRUE)

#Create vertical plot
MCMCplot(MCMC_data, params = 'beta', horiz = FALSE)

}
