\name{cv.m.clime} \alias{cv.m.clime}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{k-fold cross validation for m.clime object}
\description{
  Perform a k-fold cross validation for selecting tau.
}
\usage{ cv.m.clime(m.clime.obj, loss=c("likelihood", "tracel2"), fold = 5) }
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{m.clime.obj}{an object of class "m.clime". Such objects can be generated by the function \code{m.clime}.
  }
  \item{loss}{
    loss to be used in cross validation.  Currently, two losses are
    available: "likelihood" and "tracel2".  Default "likelihood". See \code{details}
    for more information.
  }
  \item{fold}{
    number of folds used in cross validation.  Default 5.
  }
}

\details{
  Perform a k-fold cross validation  for selecting the tuning parameter
   \code{lambda} in clime.  Two losses are implemented currently:
  \deqn{
    \textrm{likelihood: } Tr[\Sigma \Omega] - \log|\Omega| -
    p,
  }
  and
  \deqn{
    \textrm{tracel2: } Tr[ diag(\Sigma \Omega - I)^2],
  }
  where \eqn{S_n} is the sample covariance matrix of the test data of \eqn{Z=Y-X\hat{\Gamma}} and \eqn{\Omega}
  is the precision matrix estimated using the training data.
}

\value{
  An object with S3 class \code{"cv.m.clime"}. You can use it as a
  regular R list with the following fields:
  \item{lambdaopt}{the lambda selected by cross validation to minimize the loss over
    the grid values of \code{tau}.}
  \item{tauopt}{the tau selected by cross validation to minimize the loss over
    the grid values of \code{tau}.}
  \item{lambda}{sequence of \code{lambda} used in the program.}
  \item{tau}{sequence of \code{tau} used in the program.}
  \item{loss}{loss used in the program.}
  \item{loss.mean}{average k-fold loss values for each grid value (\code{lambda},\code{tau}).
  }
  \item{loss.sd}{
    standard deviation of k-fold loss values for each grid value (\code{lambda},\code{tau}).
  }
  \item{\code{lpfun.Gamma}}{Linear programming solver used for estimating the regression coefficient.}
  \item{\code{lpfun.Omega}}{Linear programming solver used for estimating the precision matrix.}
}

\references{Cai, T.T., Li, H., Liu, W., and Xie, J. (2010).   \emph{
     Simultaneous estimation of the regression coefficients and precision matrix.
  } Technical Report, University of Pennsylvania.
}

\author{T. Tony Cai,  Hongzhe Li, Weidong Liu and Jichun Xie.\cr
  Maintainer: Jichun Xie \email{jichun@mail.med.upenn.edu} }


% \note{
% \section{TODO}{More features will be added very soon.}
% }

\examples{
set.seed(922)
x <- matrix(rnorm(1500,sd=0.5),50,30)
Gamma0 <- matrix(rnorm(600),30,20)*matrix(rbinom(600,1,0.2),30,20)

Omega0.tmp <- matrix(rnorm(400),20,20)*matrix(rbinom(400,1,0.1),20,20)
Omega0.tmp <- (Omega0.tmp+t(Omega0.tmp))
diag(Omega0.tmp) <- 1
Omega0 <- make.pd(Omega0.tmp,cond.num=20)

v <- matrix(rnorm(1000),50,20)
y <- x%*%Gamma0+v%*%Mpower(solve(Omega0),1/2)

## Solve for the m.clime object.
mc.obj <- m.clime(x,y,lambda.min= 0.05,lambda.max=0.4,nlambda=5,
    tau.min=0.05,tau.max=0.4,ntau=5,linsolver.Gamma="simplex",
    linsolver.Omega="simplex")

## Choose the best fist stage estimator of the regression coefficient using cross-validation.
cv.mc.obj <- cv.m.clime(mc.obj)
lambdaopt <- cv.mc.obj$lambdaopt
tauopt <- cv.mc.obj$tauopt

## Resove the m.clime object using the selected tuning parameter.
mc2.obj <- m.clime(x,y,lambda=lambdaopt,tau=tauopt,linsolver.Gamma="simplex",
    linsolver.Omega="simplex")
mc2.obj
}
\keyword{models}
\keyword{multivariate}
