% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.jags.R
\name{write.likelihood}
\alias{write.likelihood}
\title{Adds sections of JAGS code for an MBNMA model that correspond to the
likelihood}
\usage{
write.likelihood(
  model,
  timecourse,
  rho = 0,
  covar = "varadj",
  link = "identity",
  fun
)
}
\arguments{
\item{model}{A character object of JAGS MBNMA model code}

\item{timecourse}{A character object representing the time-course used in the MBNMA model}

\item{rho}{The correlation coefficient when modelling within-study correlation between time points. The default is a string representing a
prior distribution in JAGS, indicating that it be estimated from the data (e.g. \code{rho="dunif(0,1)"}). \code{rho} also be assigned a
numeric value (e.g. \code{rho=0.7}), which fixes \code{rho} in the model to this value (e.g. for use in a deterministic sensitivity analysis).
If set to \code{rho=0} (the default) then this implies modelling no correlation between time points.}

\item{covar}{A character specifying the covariance structure to use for modelling within-study correlation between time-points. This can
be done by specifying one of the following:
\itemize{
\item \code{"varadj"} - a univariate likelihood with a variance adjustment to assume a constant correlation between subsequent
time points \insertCite{jansen2015}{MBNMAtime}. This is the default.
\item \code{"CS"} - a multivariate normal likelihood with a
\href{https://support.sas.com/resources/papers/proceedings/proceedings/sugi30/198-30.pdf}{compound symmetry} structure
\item \code{"AR1"} - a multivariate normal likelihood with an
\href{https://support.sas.com/resources/papers/proceedings/proceedings/sugi30/198-30.pdf}{autoregressive AR1} structure
}}

\item{link}{Can take either \code{"identity"} (the default),
\code{"log"} (for modelling Ratios of Means \insertCite{friedrich2011}{MBNMAtime}) or
\code{"smd"} (for modelling Standardised Mean Differences - although this also corresponds to an identity link function).}

\item{fun}{An object of class \code{"timefun"} generated (see Details) using any of
\code{tloglin()}, \code{tpoly()}, \code{titp()}, \code{temax()}, \code{tfpoly()}, \code{tspline()} or \code{tuser()}}
}
\value{
A character vector of JAGS MBNMA model code that includes likelihood
components of the model
}
\description{
Adds sections of JAGS code for an MBNMA model that correspond to the
likelihood
}
