% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{radian.rescale}
\alias{radian.rescale}
\title{Calculate position of label with respect to vertex location within a circle}
\usage{
radian.rescale(x, start = 0, direction = 1)
}
\arguments{
\item{x}{A numeric vector of positions around a circle, typically sequentially numbered.}

\item{start}{A number giving the offset from 12 o'clock in radians for the label locations.}

\item{direction}{Either \code{1} for clockwise numbering (based on the order of \code{x}) or \code{-1} for
anti-clockwise.}
}
\description{
Useful for graphs drawn using \code{igraph} to reposition labels relative to vertices when vertices
are laid out in a circle (as is common in network plots). \code{igraph} interprets position within
\code{vertex.label.degree} as radians, so it is necessary to convert locations into radian values. This
is the main role of this function.
}
\examples{
MBNMAtime:::radian.rescale(c(1:10), start=0, direction=1)

}
\references{
https://gist.github.com/kjhealy/834774/a4e677401fd6e4c319135dabeaf9894393f9392c
}
