% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{goutSUA_CFBcomb}
\alias{goutSUA_CFBcomb}
\title{Studies of combined treatments for reducing serum uric acid in patients with gout}
\format{
A data frame with 224 rows and 7 variables:
\itemize{
\item \code{studyID} Study identifiers
\item \code{time} Numeric data indicating follow-up times
\item \code{y} Numeric data indicating the mean response for a given observation
\item \code{se} Numeric data indicating the standard error for a given observation
\item \code{treatment} Treatment identifiers as factors. Labels are shortened treatment names.
\item \code{treatname} Character data giving the full names of each treatment in the format agent_dose
\item \code{class} Shortened agent names stored as factors.
}
}
\source{
Pfizer Ltd.
}
\usage{
goutSUA_CFBcomb
}
\description{
A dataset from a systematic review of interventions for lowering Serum Uric Acid (SUA) concentration in
patients with gout \strong{(not published previously)}. The outcome is continuous, and aggregate data responses
correspond to the mean change from baseline in SUA in mg/dL.
Treatments with similar doses have been pooled together to improve
network connectivity and facilitate evidence synthesis, resulting in 19 treatments of 7 agents included
in the network. Standard deviations have been imputed for 181 observations.
}
\details{
\code{goutSUA_CFBcomb} is a data frame in long format (one row per observation, arm and study),
with the variables \code{studyID}, \code{time}, \code{y}, \code{se}, \code{treatment}, \code{treatname} and \code{class}.
}
\keyword{datasets}
