% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.functions.R
\name{write.ref.synth}
\alias{write.ref.synth}
\title{Write MBNMA time-course models JAGS code for synthesis of studies
investigating reference treatment}
\usage{
write.ref.synth(fun = "linear", user.fun = NULL, alpha = "arm",
  beta.1 = "rel.common", beta.2 = NULL, beta.3 = NULL,
  beta.4 = NULL, positive.scale = TRUE, intercept = TRUE,
  rho = NULL, covar = NULL, mu.synth = "random",
  class.effect = list(), UME = FALSE, priors = NULL)
}
\arguments{
\item{fun}{is a character specifying a functional form to be assigned to the
time-course. Options are given in \code{details}.}

\item{user.fun}{A character specifying any relationship including \code{time} and
one/several of: \code{alpha}, \code{beta.1}, \code{beta.2}, \code{beta.3}, \code{beta.4}.}

\item{alpha}{Refers to the baseline mean response and is a character object
that can take either:
\itemize{
\item \code{"study"} to constrain baseline to be equal for all
arms within a study (\code{i} index is added))
\item \code{"arm"} to allow baseline to
vary between arms within a study (\code{i,k} index is added)).
}}

\item{beta.1}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.2}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.3}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.4}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{positive.scale}{A boolean object that indicates whether all continuous
mean responses (y) are positive and therefore whether the baseline response
should be given a prior that constrains it to be positive.}

\item{intercept}{A boolean object that indicates whether an intercept is to
be included in the model. Can be used to imply whether mean responses in
data are change from baseline (\code{FALSE}) or not (setting it to \code{FALSE}
removes the intercept, \code{alpha}, from the model).}

\item{rho}{The correlation coefficient when modelling correlation between time points. If left
as \code{NULL} (the default) then this implies modelling no correlation between time points.
Can either be assigned the string \code{"estimate"} to indicate that rho should be estimated
from the data, or assigned a numeric value, which fixes \code{rho} in the model to the assigned
value, either for when \code{rho} is calculated externally or for use in deterministic sensitivity
analyses.}

\item{covar}{A character specifying the covariance structure to use for the
multivariate normal likelihood. Can currently take either \code{"CS"} (compound
symmetry) or \code{"AR1"} (autoregressive AR1).}

\item{mu.synth}{A string that takes the value \code{fixed} or \code{random}, indicating
the type of synthesis model to use}

\item{class.effect}{A list of named strings that determines which time-course
parameters to model with a class effect and what that effect should be
(\code{"common"} or \code{"random"}). For example: \code{list("beta.2"="common", "beta.3"="random")}.}

\item{UME}{Can take either \code{TRUE} or \code{FALSE} (for an unrelated mean effects
model on all or no time-course parameters respectively) or can be a vector
of parameter name strings to model as UME. For example: \code{c("beta.1", "beta.2")}.}

\item{priors}{A named list of parameter values (without indices) and
replacement prior distribution values given as strings
\strong{using distributions as specified in JAGS syntax}.}
}
\value{
A character object of JAGS MBNMA model code that includes beta
parameter components of the model
}
\description{
Writes JAGS code for a Bayesian time-course model for model-based network
meta-analysis (MBNMA) that pools reference treatment effects from different
studies. This model only pools single study arms and therefore does not pool
relative effects.
}
\examples{
# Write an exponential time-course MBNMA synthesis model
model <- write.ref.synth(fun="exponential",
  alpha="arm", beta.1="rel.common", mu.synth="fixed")
cat(model) # Concatenates model representations making code more easily readable

}
