% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{timeplot}
\alias{timeplot}
\title{Plot raw responses over time by treatment or class}
\usage{
timeplot(network, level = "treatment", ...)
}
\arguments{
\item{network}{An object of class \code{mb.network}.}

\item{level}{A string indicating whether nodes/facets should represent \code{treatment}
or \code{class} in the plot. Can be used to examine the expected impact of modelling
class/agent effects.}

\item{...}{Arguments to be sent to \code{ggplot}}
}
\value{
The function returns an object of \code{class(c("gg", "ggplot")}. Characteristics
of the object can therefore be amended as with other plots generated by \code{ggplot()}.
A message will indicate if data are assumed to be change from baseline (i.e. if there
are no responses in the data at time=0). In this case responses will be set to 0 at
time=0.
}
\description{
Plot raw responses over time by treatment or class
}
\details{
Plots can be faceted by either treatment (\code{level="treatment"}) or class
(\code{level="class"}) to investigate similarity of treatment responses within classes/agents.
Points represent observed responses and lines connect between observations within the
same study and arm.
}
\examples{
# Make network
network <- mb.network(goutSUA_CFB)

# Use timeplot to plot responses grouped by treatment
timeplot(network)

# Use timeplot ot plot resposes grouped by class
timeplot(network, level="class")

}
