% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{mb.validate.data}
\alias{mb.validate.data}
\title{Validates that a dataset fulfills requirements for MBNMA}
\usage{
mb.validate.data(data.ab, single.arm = FALSE, CFB = TRUE)
}
\arguments{
\item{data.ab}{A data frame of arm-level data in "long" format containing the columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{time} Numeric data indicating follow-up times
\item \code{y} Numeric data indicating the aggregate response for a given observation (e.g. mean)
\item \code{se} Numeric data indicating the standard error for a given observation
\item \code{treatment} Treatment identifiers (can be numeric, factor or character)
\item \code{class} An optional column indicating a particular class identifier. Observations with the same treatment
identifier must also have the same class identifier.
\item \code{N} An optional column indicating the number of participants used to calculate the
response at a given observation
}}

\item{single.arm}{A boolean object to indicate whether or not function should allow singe arm studies to
be allowed in the network without returning an error. Default is not to allow their inclusion (\code{single.arm=FALSE})}

\item{CFB}{A boolean object to indicate if the dataset is composed of studies measuring change from
baseline (\code{TRUE}) or not (\code{FALSE}). It is not essential to specify this correctly but failing to do so
may lead to warnings.}
}
\value{
An error or warnings if checks are not passed. Runs silently if checks are passed
}
\description{
Validates that a dataset fulfills requirements for MBNMA
}
\details{
Checks done within the validation:
\itemize{
\item Checks data.ab has required column names
\item Checks there are no NAs
\item Checks that all SEs are positive
\item Checks that studies have baseline measurement (unless change from baseline data is being used)
\item Checks that arms are balanced at each time point
\item Checks that class codes are consistent within each treatment
\item Checks that treatment codes are consistent across different time points within a study
\item Checks that studies have at least two arms (if \code{single.arm = FALSE})
}
}
