% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbnma-class.R
\name{rank.mbnma}
\alias{rank.mbnma}
\title{Rank parameter estimates}
\usage{
\method{rank}{mbnma}(
  x,
  params = NULL,
  lower_better = TRUE,
  level = "agent",
  to.rank = NULL,
  ...
)
}
\arguments{
\item{x}{An object on which to apply the rank method}

\item{params}{A character vector of named parameters in the model that vary by either agent
or class (depending on the value assigned to \code{level}). If left as \code{NULL} (the default), then
ranking will be calculated for all available parameters that vary by agent/class.}

\item{lower_better}{Indicates whether negative responses are better (\code{TRUE}) or positive responses are better (\code{FALSE})}

\item{level}{Can be set to \code{"agent"} to rank across different agents or \code{"class"} to rank
across different classes.}

\item{to.rank}{A numeric vector containing the codes for the agents/classes you wish to rank.
If left \code{NULL} then all agents/classes (depending on the value assigned to \code{level}) in
the model will be ranked. Included codes must be greater than
\code{2} if placebo has been modelled, since placebo cannot be included in the ranking}

\item{...}{Arguments to be passed to methods}
}
\value{
An object of \code{class("mbnma.rank")} which is a list containing a summary data
frame, a matrix of rankings for each MCMC iteration, a matrix of probabilities
that each agent has a particular rank, and a matrix of cumulative ranking probabilities
for each agent, for each parameter that has been ranked.
}
\description{
Only parameters that vary by agent/class can be ranked.
}
\details{
Ranking cannot currently be performed on non-parametric dose-response MBNMA
}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(triptans)

# Rank selected agents from a log-linear dose-response MBNMA
loglin <- mbnma.run(network, fun=dloglin())
ranks <- rank(loglin, to.rank=c("zolmitriptan", "eletriptan", "sumatriptan"))
summary(ranks)

# Rank only ED50 parameters from an Emax dose-response MBNMA
emax <- mbnma.run(network, fun=demax(), method="random")
ranks <- rank(emax, params="ed50")
summary(ranks)


#### Ranking by class ####
# Generate some classes for the data
class.df <- triptans
class.df$class <- ifelse(class.df$agent=="placebo", "placebo", "active1")
class.df$class <- ifelse(class.df$agent=="eletriptan", "active2", class.df$class)
netclass <- mbnma.network(class.df)
emax <- mbnma.run(netclass, fun=demax(), method="random",
            class.effect=list("ed50"="common"))

# Rank by class, with negative responses being worse
ranks <- rank(emax, level="class", lower_better=FALSE)
print(ranks)

# Print and generate summary data frame for `mbnma.rank` object
summary(ranks)
print(ranks)

# Plot `mbnma.rank` object
plot(ranks)
}

}
