% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose.functions.R
\name{dfpoly}
\alias{dfpoly}
\title{Fractional polynomial dose-response function}
\usage{
dfpoly(
  degree = 1,
  beta.1 = "rel",
  beta.2 = "rel",
  power.1 = "common",
  power.2 = "common"
)
}
\arguments{
\item{degree}{The degree of the fractional polynomial as defined in  \insertCite{royston1994;textual}{MBNMAdose}}

\item{beta.1}{Pooling for the 1st fractional polynomial coefficient. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{beta.2}{Pooling for the 2nd fractional polynomial coefficient. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{power.1}{Pooling for the 1st fractional polynomial power (\eqn{\gamma_1}). Can take \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{power.2}{Pooling for the 2nd fractional polynomial power (\eqn{\gamma_2}). Can take \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}
}
\value{
An object of \code{class("dosefun")}
}
\description{
Fractional polynomial dose-response function
}
\details{
\itemize{
\item \eqn{\beta_1} represents the 1st coefficient.
\item \eqn{\beta_2} represents the 2nd coefficient.
\item \eqn{\gamma_1} represents the 1st fractional polynomial power
\item \eqn{\gamma_2} represents the 2nd fractional polynomial power
}

For a polynomial of \code{degree=1}:
\deqn{{\beta_1}x^{\gamma_1}}

For a polynomial of \code{degree=2}:
\deqn{{\beta_1}x^{\gamma_1}+{\beta_2}x^{\gamma_2}}

\eqn{x^{\gamma}} is a regular power except where \eqn{\gamma=0}, where \eqn{x^{(0)}=ln(x)}.
If a fractional polynomial power \eqn{\gamma} repeats within the function it is multiplied by another \eqn{ln(x)}.
}
\section{Dose-response parameters}{
\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Implies that \emph{relative} effects should be pooled for this dose-response parameter separately for each agent in the network. \cr
   \code{"common"} \tab Implies that all agents share the same common effect for this dose-response parameter. \cr
   \code{"random"} \tab Implies that all agents share a similar (exchangeable) effect for this dose-response parameter. This approach allows for modelling of variability between agents. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this dose-response parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific dose-response parameters (e.g. Hill parameters in Emax functions) to a single value. \cr
}


When relative effects are modelled on more than one dose-response parameter,
correlation between them is automatically estimated using a vague inverse-Wishart prior.
This prior can be made slightly more informative by specifying the scale matrix \code{omega}
and by changing the degrees of freedom of the inverse-Wishart prior
using the \code{priors} argument in \code{mbnma.run()}.
}

\examples{
# 1st order fractional polynomial a value of 0.5 for the power
dfpoly(beta.1="rel", power.1=0.5)

# 2nd order fractional polynomial with relative effects for coefficients
# and a common and random pooling for the 1st and 2nd power respectively
dfpoly(degree=2, beta.1="rel", beta.2="rel",
  power.1="common", power.2="random")

}
\references{
\insertAllCited
}
