% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepAIC_BIC.R
\name{step_down}
\alias{step_down}
\title{Naive backeward elimination}
\usage{
step_down(object, ..., trace = FALSE, k)
}
\arguments{
\item{object}{A fitted model object}

\item{...}{additional arguments passed to \code{\link{drop_term}} such as \code{k}}

\item{trace}{logical: do you want a trace of the process printed?}

\item{k}{penalty (default 2, as for AIC)}
}
\value{
A refined fitted model object
}
\description{
A simple facility to refine models by backward elimination.
Covers cases where \code{\link{drop_term}} works but \code{\link{step_AIC}}
does not
}
\examples{
fm <- lm(medv ~ . + (rm + tax + lstat)^2 +
           I((rm - 6)^2) + I((tax - 400)^2) + I((lstat - 12)^2), Boston)
sfm <- step_down(fm, trace = TRUE, k = "bic")
}
