% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepAIC_BIC.R
\name{GIC}
\alias{GIC}
\title{Intermediate Information Criterion}
\usage{
GIC(object)
}
\arguments{
\item{object}{a fitted model object for which the criterion is desired}
}
\value{
The GIC criterion value
}
\description{
An AIC-variant criterion that weights complexity with a penalty
mid-way between 2 (as for AIC) and log(n) (as for BIC).  I.e.
"not too soft" and "not too hard", just "Glodilocks".
}
\examples{
gm <- glm.nb(Days ~ Sex/(Age + Eth*Lrn), quine)
c(AIC = AIC(gm), GIC = GIC(gm), BIC = BIC(gm))
}
