% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_02_DETECT_EVENTS_1_0_ALE.R
\name{DetectEvents.ALE}
\alias{DetectEvents.ALE}
\title{Detect alternative last exons}
\usage{
DetectEvents.ALE(
  MarvelObject,
  min.cells = 50,
  min.expr = 1,
  track.progress = FALSE
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CreateMarvelObject} function.}

\item{min.cells}{Numeric value. The minimum number of cells in which the gene is expressed for the gene to included for splicing event detected and quantification. To be used in conjunction with \code{min.expr} argument. Default value is \code{50}.}

\item{min.expr}{Numeric value. The minimum expression value for the gene to be considered to be expressed in a cell. Default value is \code{1}.}

\item{track.progress}{Logical. If set to \code{TRUE}, progress bar will appear to track the progress of the rate-limiting step of this function, which is the extraction of the final exon-exon junctions. Default value is \code{FALSE}.}
}
\value{
An object of class S3 with new slot \code{MarvelObject$SpliceFeature$ALE}.
}
\description{
Detects alternative last exons from GTF. This is a wrapper function for \code{DetectEvents.ALE.PosStrand} and \code{DetectEvents.ALE.NegStrand} functions.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- DetectEvents.ALE(MarvelObject=marvel.demo,
                                min.cells=5,
                                min.expr=1,
                                track.progress=FALSE
                                )
}
