% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_05_1_PlotValues_PSI.R
\name{PlotValues.PSI}
\alias{PlotValues.PSI}
\title{Plot Percent Spliced-in (PSI) Values}
\usage{
PlotValues.PSI(MarvelObject, cell.types, feature, maintitle, xlabels.size,
  n.cells, sigma.sq, bimodal.adjust, seed, modality.column)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} or \code{ComputePSI} function.}

\item{cell.types}{Character string. To indicate which groups of cells that will be used for plotting. Group names should match those in \code{cell.type} column of \code{$SplicePheno} slot.}

\item{feature}{Character string. \code{tran_id} for plotting. Should match \code{tran_id} column of \code{$ValidatedSpliceFeature} slot.}

\item{maintitle}{Character string. Column to use as plot main title as per \code{ValidatedSpliceFeature}.}

\item{xlabels.size}{Numeric value. Size of x-axis labels as per \code{ggplot2} function.}

\item{n.cells}{Numeric value. The minimum no. of cells expressing the splicing event to be included for analysis.}

\item{sigma.sq}{Numeric value. The variance threshold below which the included/excluded modality will be defined as primary sub-modality, and above which it will be defined as dispersed sub-modality. Please refer to \code{AssignModality} function help page for more details.}

\item{bimodal.adjust}{Logical. When set to \code{TRUE}, MARVEL will identify false bimodal modalities and reassign them as included/excluded modality. Please refer to \code{AssignModality} function help page for more details.}

\item{seed}{Numeric value. Ensure the \code{fitdist} function returns the same values for alpha and beta paramters each time this function is executed using the same random number generator. Please refer to \code{AssignModality} function help page for more details.}

\item{modality.column}{Character string. Can take the value \code{"modality"}, \code{"modality.var"} or \code{"modality.bimodal.adj"}. Please refer to \code{AssignModality} function help page for more details.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{$adhocPlot$PSI}.
}
\description{
\code{PlotValues.PSI} plots percent spliced-in (PSI) values across different groups of cells.
}
\details{
This function plots percent spliced-in (PSI) across different groups of cells. Violin plot is used for PSI values.
}
\examples{
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

feature <- marvel$SpliceFeature$SE$tran_id[1]

marvel <- PlotValues.PSI(MarvelObject=marvel,
                         cell.types=c("iPSC", "Endoderm"),
                         feature=feature,
                         maintitle="gene_short_name",
                         xlabels.size=12,
                         n.cells=25,
                         sigma.sq=0.001,
                         bimodal.adjust=TRUE,
                         seed=1,
                         modality.column="modality.bimodal.adj"
                         )

marvel$adhocPlot$PSI
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
