% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multRM-function.R
\name{multRM}
\alias{multRM}
\title{Tests for Repeated Measures in Multivariate Semi-Parametric Factorial Designs}
\usage{
multRM(formula, data, subject, within, iter = 10000, alpha = 0.05,
  resampling = "paramBS", para = FALSE, CPU, seed, dec = 3)
}
\arguments{
\item{formula}{A model \code{\link{formula}} object. The left hand side
contains the matrix of response variables (using cbind()) and the right hand side 
contains the factor variables of interest. The within-subject factors must be specified
 last in the formula, e.g. \code{cbind(outcome1, outcome2) ~ between1 * between2 * within1 * within2}.}

\item{data}{A data.frame, list or environment containing the variables in 
\code{formula}. Data must be in long format and must not contain missing values.}

\item{subject}{The column name of the subjects in the data. NOTE: Subjects within 
different groups of between-subject factors must have individual labels, see Details for 
more explanation.}

\item{within}{Specifies the within-subject factor(s) in the formula.}

\item{iter}{The number of iterations used for calculating the resampled 
statistic. The default option is 10,000.}

\item{alpha}{A number specifying the significance level; the default is 0.05.}

\item{resampling}{The resampling method to be used, one of "paramBS" (parametric bootstrap
approach) and "WildBS" (wild bootstrap approach with Rademacher weights).}

\item{para}{If parallel computing should be used. Default is FALSE.}

\item{CPU}{The number of cores used for parallel computing. If not specified, cores
are detected via \code{\link[parallel]{detectCores}}.}

\item{seed}{A random seed for the resampling procedure. If omitted, no 
reproducible seed is set.}

\item{dec}{Number of decimals the results should be rounded to. Default is 3.}
}
\value{
A \code{MANOVA} object containing the following components:
 \item{Descriptive}{Some descriptive statistics of the data for all factor 
  level combinations. Displayed are the number of individuals per factor 
  level combination and the vector of means (one column per dimension).}
  \item{Covariance}{The estimated covariance matrix.} 
  \item{WTS}{The value of the WTS along with degrees of freedom of the
  central chi-square distribution and p-value.} 
  \item{MATS}{The value of the MATS.} 
  \item{resampling}{p-values for the test statistic based on the
  chosen resampling approach.}
}
\description{
The multRM() function calculates the Wald-type statistic (WTS) and the modified ANOVA-type 
statistic (MATS) as well as resampling versions of these test statistics for multivariate
semi-parametric repeated measures designs.
}
\details{
The multRM() function provides the Wald-type
 statistic as well as the modified ANOVA-type statistic (Friedrich and Pauly, 2018) for repeated measures
 designs with multivariate metric outcomes.
 These methods are even applicable for non-normal error terms and/or heteroscedastic
 variances. Implemented are designs with an arbitrary number of 
 between-subject (whole-plot) and within-subject (sub-plot) factors and the methods
 allow for different sample sizes. In addition to the
 asymptotic p-values, p-values based on resampling
 approaches are provided.
 NOTE: The within-subject factors need to be specified in the
 function call (\code{within =}).
 
 If subjects in different groups of the between-subject factor have the same id, they will 
 not be identified as different subjects and thus it is erroneously assumed that their 
 measurements belong to one subject. See \code{\link{RM}} for more explanations and an example.
}
\examples{
\dontrun{
data(EEG)
library(tidyr)
eeg <- spread(EEG, feature, resp)
fit <- multRM(cbind(brainrate, complexity) ~ sex * region, data = eeg, 
              subject = "id", within = "region")
summary(fit)
}

}
\references{
Friedrich, S., Brunner, E. and Pauly, M. (2017). Permuting longitudinal
 data in spite of the dependencies. Journal of Multivariate Analysis, 153, 255-265.

  Bathke, A., Friedrich, S., Konietschke, F., Pauly, M., Staffen, W., Strobl, N. and 
  Hoeller, Y. (2018). Testing Mean Differences among Groups: Multivariate and Repeated 
  Measures Analysis with Minimal Assumptions. Multivariate Behavioral Research, 53(3), 348-359,
  Doi: 10.1080/00273171.2018.1446320.
 
  Friedrich, S., Konietschke, F., Pauly, M. (2017). GFD - An 
  R-package for the Analysis of General Factorial Designs. 
  Journal of Statistical Software, 79(1), 1-18.
  
   Friedrich, S., and Pauly, M. (2018). MATS: Inference for potentially singular and
  heteroscedastic MANOVA. Journal of Multivariate Analysis, 165, 166-179.
}
\seealso{
\code{\link{RM}}, \code{\link{MANOVA}}
}
