% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_OrthoMCL.R
\name{analyze_OrthoMCL}
\alias{analyze_OrthoMCL}
\title{Main OrthoMCL Analysis}
\usage{
analyze_OrthoMCL(mcl_data, pheno_data, model, species_name, resp = NULL,
  fix2 = NULL, rndm1 = NULL, rndm2 = NULL, multi = 1, time = NULL,
  event = NULL, time2 = NULL, startnum = 1, stopnum = "end",
  output_dir = NULL, sig_digits = NULL)
}
\arguments{
\item{mcl_data}{output of format_afterOrtho --list of 2 things-- 1: binary matrix indicating the presence / absence of genes in each OG and 2: vector of names of OGs}

\item{pheno_data}{a data frame with column names of the following variables}

\item{model}{Linear Model with gene presence as fixed effect (lm),Linear Mixed Effect models with gene presence as fixed effect and additional variables specified as: one random effect (lmeR1); two independent random effects (lmeR2ind); two random effects with rndm2 nested in rndm1 (lmeR2nest); or two independent random effects with one additional fixed effect (lmeF2), Wilcox Test with gene presence as fixed effect (wx), Survival Test with support for multi core design (survmulti), and with (survmulticensor)}

\item{species_name}{Column name in pheno_data containing 4-letter species designations}

\item{resp}{Column name in pheno_data containing response variable}

\item{fix2}{Column name in pheno_data containing second fixed effect}

\item{rndm1}{Column name in pheno_data containing first random variable}

\item{rndm2}{Column name in pheno_data containing second random variable}

\item{multi}{(can only be used with survival tests) Number of cores}

\item{time}{(can only be used with survival tests) Column name in pheno_data containing first time}

\item{event}{(can only be used with survival tests) Column name in pheno_data containing event}

\item{time2}{(can only be used with survival tests) Column name in pheno_data containing econd time}

\item{startnum}{number of test to start on}

\item{stopnum}{number of test to stop on}

\item{output_dir}{if using survival tests, where small output files will be placed before using surv_append_matrix. Must specify a directory if choosign to output small files, else only written as a matrix}

\item{sig_digits}{amount of digits to display for p-values and means of data; default to no rounding}
}
\value{
A matrix with the following columns: OG, p-values, Bonferroni corrected p-values, mean phenotype of OG-containing taxa, mean pheotype of OG-lacking taxa, taxa included in OG, taxa not included in OG
}
\description{
Main function for analyzing the statistical association of PDG (phylogenetic distribution group) presence with phenotype data
}
\examples{
#Linear Model
mcl_mtrx <- analyze_OrthoMCL(after_ortho_format, pheno_data, 'lm',
 'Treatment', resp='RespVar')


# the rest of the examples are not run for time's sake
#Linear Mixed Effect with one random effect
\dontrun{
mcl_mtrx <- analyze_OrthoMCL(after_ortho_format, pheno_data, 'lmeR1',
'Treatment', resp='RespVar', rndm1='Experiment')
}

\dontrun{
#Linear Mixed Effect with two independent random effects
mcl_mtrx <- analyze_OrthoMCL(after_ortho_format, pheno_data, 'lmeR2ind',
 'Treatment', resp='RespVar', rndm1='Experiment', rndm2='Vial')
}

\dontrun{
#Linear Mixed Effect with rndm2 nested in rndm1
mcl_mtrx <- analyze_OrthoMCL(after_ortho_format, pheno_data, 'lmeR2nest',
 'Treatment',  resp='RespVar', rndm1='Experiment', rndm2='Vial')
}

\dontrun{
#Linear Mixed Effect with two independent random effects and one additional fixed effect
mcl_mtrx <- analyze_OrthoMCL(after_ortho_format, pheno_data, 'lmeF2',
 'Treatment', resp='RespVar', fix2='Treatment', rndm1='Experiment', rndm2='Vial')
}

\dontrun{
#Wilcox Test
mcl_mtrx <- analyze_OrthoMCL(after_ortho_format, pheno_data, 'wx',
 'Treatment', resp='RespVar')
}

# Not run ~ 5 minutes
#Survival with two independent random effects, run on multiple cores
\dontrun{
mcl_mtrx <- analyze_OrthoMCL(after_ortho_format, starv_pheno_data, 'TRT', model='survmulti',
 time='t2', event='event', rndm1='EXP', rndm2='VIAL', multi=1)
}

# Not run ~ 5 minutes
#Survival with two independent random effects and one additional fixed effect,
#including drops on multi cores
\dontrun{
mcl_mtrx <- analyze_OrthoMCL(after_ortho_format, starv_pheno_data, 'TRT', model='survmulticensor',
 time='t1', time2='t2', event='event', rndm1='EXP', rndm2='VIAL', fix2='BACLO', multi=1)
 }
#to be appended with surv_append_matrix
}
