% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMAFDashboard.R
\name{getMAFDashboard}
\alias{getMAFDashboard}
\title{Function to generate a dashboard from a MAF file.}
\usage{
getMAFDashboard(
  MAFfilePath = NULL,
  plotList = NULL,
  outputFileName = "dashboard.html",
  outputFileTitle = "MAF Dash",
  outputFilePath = tempdir()
)
}
\arguments{
\item{MAFfilePath}{The path of the file containing the mutation
information in the MAF format}

\item{plotList}{A named list denoting which plots to draw.
List elements can be:
- boolean, if the name matches one of built-in plots: "summary_plot","burden","oncoplot","cooccurence","heatmap"
- ggplot, ComplexHeatmap, or plotly object
- file path to image (must be absolute path)
The default value (if set to NULL) is 'list("summary_plot"=TRUE,"burden"=TRUE,"oncoplot"=TRUE,"cooccurence"=TRUE,"heatmap"=TRUE)'
The order of the list determines the order of the tabs, and list names are used as tab titles.}

\item{outputFileName}{The name of the output html dashboard
file}

\item{outputFileTitle}{The title of the output html dashboard}

\item{outputFilePath}{The path of the output html dashboard}
}
\value{
No return value, the MAF dashboard html file is created in the given output folder
}
\description{
This function creates an HTML file containing the
different figures and plots explaining the MAF dataset.
}
\examples{
library(MAFDash)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
\donttest{getMAFDashboard(MAFfilePath = maf,outputFilePath=tempdir())}
}
\author{
Mayank Tondon, Ashish Jain
}
