% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetScenario.R
\name{GetScenario}
\alias{GetScenario}
\title{Returns the superiority or futility cutoff during a MABOUST trial.}
\usage{
GetScenario(nTreat, RANGES, RANGES1, XPROB)
}
\arguments{
\item{nTreat}{Number of active treatments in consideration, i.e. 1,...,K.}

\item{RANGES}{J-list containing ranges of plausible marginal treatment outcome probabilities.}

\item{RANGES1}{J-list containing ranges of plausible covariate adjusted outcome probabilities.}

\item{XPROB}{List of matrices containing discrete values various covariates can take, along with their probabilities.}
}
\value{
Randomly generate marginal ordinal outcome probabilities for each treatment and a covariate vector.
}
\description{
Returns the superiority or futility cutoff during a MABOUST trial.
}
\examples{
###Trial parameters
nTreat = 3
nCat=6
###Marginal Probability Ranges
RANGES = as.list(rep(NA,nCat))
RANGES[[1]]=c(.1,.35)
RANGES[[2]]=c(.1,.3)
RANGES[[3]]=c(.4,.7)
RANGES[[4]]=c(0,.1)
RANGES[[5]]=c(.1,.3)
RANGES[[6]]=c(.0,.1)
###Covariate Adjusted Probability Ranges
RANGES1=RANGES
RANGES1[[1]]=c(0,.5)
RANGES1[[2]]=c(0,.5)
RANGES1[[3]]=c(0,.8)
RANGES1[[4]]=c(0,.45)
RANGES1[[5]]=c(0,.45)
RANGES1[[6]]=c(0,.30)
XPROB = as.list(rep(NA,3))
XPROB[[1]]=rbind(0:10,round(dpois(0:10,2),2)) ###CCI
XPROB[[2]]=rbind(c(-1,0,1),c(.5,.4,.1)) ###O2 Status
XPROB[[3]]=rbind(c(-2,-1,0,1),c(.27,.38,.18,.17))
GetScenario(nTreat,RANGES,RANGES1, XPROB)
}
\references{
[1] Chapple and Clement (2020), MABOUST: A Multi-Armed Bayesian Ordinal Outcome Utility-Based Sequential Trial. Submitted.
}
