% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m4functions.R
\name{plot.M4ts}
\alias{plot.M4ts}
\title{Plot an M4 time series}
\usage{
\method{plot}{M4ts}(x, xlim = c(tsp(x$past)[1], tsp(x$future)[2]),
  ylim = range(x$past, x$future), main = x$id, xlab = "",
  ylab = x$units, ...)
}
\arguments{
\item{x}{an M4ts object}

\item{xlim}{Limits on x-axis}

\item{ylim}{Limits on y-axis}

\item{main}{Main title}

\item{xlab}{Label on x-axis}

\item{ylab}{Label on y-axis}

\item{...}{Other plotting arguments}
}
\value{
None. The function produces a time series plot of the M4ts object \code{x}.
}
\description{
\code{plot.M4ts} plots a time series from the M4 competition data set.
}
\examples{
plot(M4[[1]])
}

