% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_RLum.Data.R
\name{bin_RLum.Data}
\alias{bin_RLum.Data}
\title{Channel binning - method dispatcher}
\usage{
bin_RLum.Data(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum.Data} (\strong{required}):
S4 object of class \code{RLum.Data}}

\item{...}{further arguments passed to the specific class method}
}
\value{
An object of the same type as the input object is provided
}
\description{
Function calls the object-specific bin functions for RLum.Data S4 class objects.
}
\details{
The function provides a generalised access point for specific
\linkS4class{RLum.Data} objects. \cr
Depending on the input object, the corresponding function will be selected.
Allowed arguments can be found in the documentations of the corresponding
\linkS4class{RLum.Data} class.
}
\note{
Currently only \code{RLum.Data} objects of class \linkS4class{RLum.Data.Curve} and \linkS4class{RLum.Data.Spectrum} are supported!
}
\section{Function version}{
 0.2.0
}

\examples{

##load example data
data(ExampleData.CW_OSL_Curve, envir = environment())

##create RLum.Data.Curve object from this example
curve <-
  set_RLum(
      class = "RLum.Data.Curve",
      recordType = "OSL",
      data = as.matrix(ExampleData.CW_OSL_Curve)
  )

##plot data without and with 2 and 4 channel binning
plot_RLum(curve)
plot_RLum(bin_RLum.Data(curve, bin_size = 2))
plot_RLum(bin_RLum.Data(curve, bin_size = 4))

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Spectrum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2023. bin_RLum.Data(): Channel binning - method dispatcher. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2023. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.22. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
