% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.Data.Image.R
\name{plot_RLum.Data.Image}
\alias{plot_RLum.Data.Image}
\title{Plot function for an \code{RLum.Data.Image} S4 class object}
\usage{
plot_RLum.Data.Image(object, par.local = TRUE,
  plot.type = "plot.raster", ...)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Image} (\strong{required}): S4
object of class \code{RLum.Data.Image}}

\item{par.local}{\link{logical} (\emph{with default}): use local graphical
parameters for plotting, e.g. the plot is shown in one column and one row.
If \code{par.local = FALSE} global parameters are inherited.}

\item{plot.type}{\link{character} (\emph{with default}): plot types.
Supported types are \code{plot.raster}, \code{plotRGB} or \code{contour}}

\item{...}{further arguments and graphical parameters that will be passed
to the specific plot functions.}
}
\value{
Returns a plot.
}
\description{
The function provides a standardised plot output for image data of an
\code{RLum.Data.Image}S4 class object, mainly using the plot functions
provided by the \link{raster} package.
}
\details{
\strong{Details on the plot functions}

Image is visualised as 2D plot usinng generic plot types provided by other
packages.

Supported plot types:

\strong{\code{plot.type = "plot.raster"}}

Uses the standard plot function for raster data from the package
\link[raster:raster]{raster::raster}: \link[raster:plot]{raster::plot}. For each raster layer in a
raster brick one plot is produced.

Arguments that are passed through the function call:

\code{main},\code{axes}, \code{xlab}, \code{ylab}, \code{xlim}, \code{ylim},
\code{col}

\strong{\code{plot.type = "plotRGB"}}

Uses the function \link[raster:plotRGB]{raster::plotRGB} from the
\link[raster:raster]{raster::raster} package. Only one image plot is produced as all layers
in a brick a combined.  This plot type is useful to see whether any signal
is recorded by the camera.\cr
Arguments that are passed through the function call:

\code{main},\code{axes}, \code{xlab}, \code{ylab}, \code{ext}, \code{interpolate}, \code{maxpixels},
\code{alpha}, \code{colNA}, \code{stretch}

\strong{\code{plot.type = "contour"}}

Uses the function contour plot function from the \link{raster}
function (\link[raster:contour]{raster::contour}). For each raster layer one contour
plot is produced. Arguments that are passed through the function call:\cr

\code{main},\code{axes}, \code{xlab}, \code{ylab}, \code{xlim}, \code{ylim},
\code{col}
}
\note{
This function has been created to faciliate the plotting of image data
imported by the function \link{read_SPE2R}. However, so far the
function is not optimized to handle image data > ca. 200 MByte and thus
plotting of such data is extremely slow.
}
\section{Function version}{
 0.1
}

\examples{

##load data
data(ExampleData.RLum.Data.Image, envir = environment())

##plot data
plot_RLum.Data.Image(ExampleData.RLum.Data.Image)

}
\seealso{
\linkS4class{RLum.Data.Image}, \link{plot}, \link{plot_RLum}, \link[raster:raster]{raster::raster}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2019. plot_RLum.Data.Image(): Plot function for an RLum.Data.Image S4 class object. Function version 0.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., 2019. Luminescence: Comprehensive Luminescence Dating Data AnalysisR package version 0.9.2. https://CRAN.R-project.org/package=Luminescence
}

\keyword{aplot}
