% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{extdata}
\alias{extdata}
\title{Collection of External Data}
\description{
Description and listing of data provided in the folder \code{data/extdata}
}
\details{
The \strong{R} package \code{Luminescence} includes a number of raw data files, which are mostly used in
the example sections of appropriate functions. They are also used internally for testing corresponding
functions using the \code{testthat} package (see files in \verb{tests/testthat/}) to ensure their operational
reliability.

\strong{Accessibility}

If the \strong{R} package \code{Luminescence} is installed correctly the preferred way to access and use these
data from within \strong{R} is as follows:

\code{system.file("extdata/<FILENAME>", package = "Luminescence")}

\strong{Individual file descriptions}

\emph{>>Daybreak_TestFile.DAT/.txt<<}

\strong{Type:} raw measurement data \cr
\strong{Device:} Daybreak OSL/TL reader\cr
\strong{Measurement date:} unknown\cr
\strong{Location:} unknown\cr
\strong{Provided by:} unknown\cr
\strong{Related R function(s):} \code{read_Daybreak2R()}\cr
\strong{Reference:} unknown

\emph{>>DorNie_0016.psl<<}

\strong{Type:} raw measurement data \cr
\strong{Device:} SUERC portable OSL reader \cr
\strong{Measurement date:} 19/05/2016 \cr
\strong{Location:} Dormagen-Nievenheim, Germany \cr
\strong{Provided by:} Christoph Burow (University of Cologne) \cr
\strong{Related R function(s):} \code{read_PSL2R()} \cr
\strong{Reference:} unpublished \cr
\strong{Additional information:} Sample measured at an archaeological site near \cr
Dormagen-Nievenheim (Germany) during a practical course on Luminescence dating in 2016. \cr

\emph{>>QNL84_2_bleached.txt}, \emph{QNL84_2_unbleached.txt<<}

\strong{Type:} Test data for exponential fits \cr
\strong{Reference:} Berger, G.W., Huntley, D.J., 1989. Test data for exponential fits. Ancient TL 7, 43-46. \cr

\emph{>>STRB87_1_bleached.txt}, \emph{STRB87_1_unbleached.txt<<}

\strong{Type:} Test data for exponential fits \cr
\strong{Reference:} Berger, G.W., Huntley, D.J., 1989. Test data for exponential fits. Ancient TL 7, 43-46.

\emph{>>XSYG_file.xsyg}

\strong{Type:} XSYG-file stump \cr
**Info: ** XSYG-file with some basic curves to test functions \cr
\strong{Reference:} no reference available
}
\keyword{datasets}
