% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.Data.Curve.R
\name{plot_RLum.Data.Curve}
\alias{plot_RLum.Data.Curve}
\title{Plot function for an RLum.Data.Curve S4 class object}
\usage{
plot_RLum.Data.Curve(object, par.local = TRUE, norm = FALSE,
  smooth = FALSE, ...)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Curve} (\strong{required}):
S4 object of class \code{RLum.Data.Curve}}

\item{par.local}{\link{logical} (\emph{with default}):
use local graphical parameters for plotting, e.g. the plot is shown in one
column and one row. If \code{par.local = FALSE}, global parameters are inherited.}

\item{norm}{\link{logical} (\emph{with default}):
allows curve normalisation to the highest count value}

\item{smooth}{\link{logical} (\emph{with default}):
provides an automatic curve smoothing based on \link[zoo:rollmean]{zoo::rollmean}}

\item{...}{further arguments and graphical parameters that will be passed
to the \code{plot} function}
}
\value{
Returns a plot.
}
\description{
The function provides a standardised plot output for curve data of an
RLum.Data.Curve S4 class object
}
\details{
Only single curve data can be plotted with this function.  Arguments
according to \link{plot}.
}
\note{
Not all arguments of \link{plot} will be passed!
}
\section{Function version}{
 0.2.3 (2018-01-21 17:22:38)
}

\examples{

##plot curve data

#load Example data
data(ExampleData.CW_OSL_Curve, envir = environment())

#transform data.frame to RLum.Data.Curve object
temp <- as(ExampleData.CW_OSL_Curve, "RLum.Data.Curve")

#plot RLum.Data.Curve object
plot_RLum.Data.Curve(temp)


}
\seealso{
\link{plot}, \link{plot_RLum}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
\cr R Luminescence Package Team} 

\section{How to cite}{
Kreutzer, S. (2018). plot_RLum.Data.Curve(): Plot function for an RLum.Data.Curve S4 class object. Function version 0.2.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.2. https://CRAN.R-project.org/package=Luminescence
}

\keyword{aplot}
