% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_BIN2R.R
\name{read_BIN2R}
\alias{read_BIN2R}
\title{Import Risoe BIN-file into R}
\usage{
read_BIN2R(file, show.raw.values = FALSE, position = NULL,
  n.records = NULL, zero_data.rm = TRUE, duplicated.rm = FALSE,
  fastForward = FALSE, show.record.number = FALSE, txtProgressBar = TRUE,
  forced.VersionNumber = NULL, pattern = NULL, verbose = TRUE, ...)
}
\arguments{
\item{file}{\code{\link{character}} or \code{\link{list}} (\bold{required}): path and file name of the
BIN/BINX file. If input is a \code{list} it should comprise only \code{character}s representing
each valid path and BIN/BINX-file names.
Alternatively the input character can be just a directory (path), in this case the
the function tries to detect and import all BIN/BINX files found in the directory.}

\item{show.raw.values}{\link{logical} (with default): shows raw values from
BIN file for \code{LTYPE}, \code{DTYPE} and \code{LIGHTSOURCE} without
translation in characters. Can be provided as \code{list} if \code{file} is a \code{list}.}

\item{position}{\code{\link{numeric}} (optional): imports only the selected position. Note:
the import performance will not benefit by any selection made here.
Can be provided as \code{list} if \code{file} is a \code{list}.}

\item{n.records}{\link{raw} (optional): limits the number of imported
records. Can be used in combination with \code{show.record.number} for
debugging purposes, e.g. corrupt BIN-files. Can be provided as \code{list} if \code{file} is a \code{list}.}

\item{zero_data.rm}{\code{\link{logical}} (with default): remove erroneous data with no count
values. As such data are usally not needed for the subsequent data analysis they will be removed
by default. Can be provided as \code{list} if \code{file} is a \code{list}.}

\item{duplicated.rm}{\code{\link{logical}} (with default): remove duplicated entries if \code{TRUE}.
This may happen due to an erroneous produced BIN/BINX-file. This option compares only
predeccessor and successor. Can be provided as \code{list} if \code{file} is a \code{list}.}

\item{fastForward}{\code{\link{logical}} (with default): if \code{TRUE} for a
more efficient data processing only a list of \code{RLum.Analysis} objects is returned instead
of a \link{Risoe.BINfileData-class} object. Can be provided as \code{list} if \code{file} is a \code{list}.}

\item{show.record.number}{\link{logical} (with default): shows record number
of the imported record, for debugging usage only. Can be provided as \code{list} if \code{file} is a \code{list}.}

\item{txtProgressBar}{\link{logical} (with default): enables or disables
\code{\link{txtProgressBar}}.}

\item{forced.VersionNumber}{\code{\link{integer}} (optional): allows to cheat the
version number check in the function by own values for cases where the
BIN-file version is not supported. Can be provided as \code{list} if \code{file} is a \code{list}.\cr
Note: The usage is at own risk, only supported BIN-file versions have been tested.}

\item{pattern}{\code{\link{character}} (optional): argument that is used if only a path is provided.
The argument will than be passed to the function \code{\link{list.files}} used internally to
construct a \code{list} of wanted files}

\item{verbose}{\code{\link{logical}} (with default): enables or disables verbose mode}

\item{\dots}{further arguments that will be passed to the function
\code{\link{Risoe.BINfileData2RLum.Analysis}}. Please note that any matching argument
automatically sets \code{fastForward = TRUE}}
}
\value{
Returns an S4 \link{Risoe.BINfileData-class} object containing two
slots:\cr \item{METADATA}{A \link{data.frame} containing all variables
stored in the bin-file.} \item{DATA}{A \link{list} containing a numeric
\link{vector} of the measured data. The ID corresponds to the record ID in
METADATA.}\cr

If \code{fastForward = TRUE} a list of \code{\linkS4class{RLum.Analysis}} object is returned. The
internal coercing is done using the function \code{\link{Risoe.BINfileData2RLum.Analysis}}
}
\description{
Import a *.bin or a *.binx file produced by a Risoe DA15 and DA20 TL/OSL
reader into R.
}
\details{
The binary data file is parsed byte by byte following the data structure
published in the Appendices of the Analyst manual p. 42.\cr\cr For the
general BIN-file structure, the reader is referred to the Risoe website:
\code{http://www.nutech.dtu.dk/}
}
\note{
The function works for BIN/BINX-format versions 03, 04, 06 and 07. The
version number depends on the used Sequence Editor.\cr\cr \bold{Potential
other BIN/BINX-format versions are currently not supported. The
implementation of version 07 support could not been tested properly so far.}.
}
\section{Function version}{
 0.14.0 (2016-05-29 17:32:46)
}
\examples{


##(1) import Risoe BIN-file to R (uncomment for usage)

#FILE <- file.choose()
#temp <- read_BIN2R(FILE)
#temp

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France), Margret C. Fuchs, HZDR Freiberg, (Germany)
\cr R Luminescence Package Team}
\references{
Duller, G., 2007. Analyst.
\url{http://www.nutech.dtu.dk/english/~/media/Andre_Universitetsenheder/Nutech/Produkter\%20og\%20services/Dosimetri/radiation_measurement_instruments/tl_osl_reader/Manuals/analyst_manual_v3_22b.ashx}
}
\seealso{
\code{\link{write_R2BIN}}, \code{\linkS4class{Risoe.BINfileData}},
\code{\link[base]{readBin}}, \code{\link{merge_Risoe.BINfileData}}, \code{\linkS4class{RLum.Analysis}}
\code{\link[utils]{txtProgressBar}}, \code{\link{list.files}}
}
\keyword{IO}

