/*
 Main driver function for R interface to Espresso..
 */

#include "espresso.h"
#include <unistd.h>

/** static jmp_buf ex_buf__; **/

#define TRY do{ ;; if( !setjmp(ex_buf__) ){
#define CATCH } else {
#define ETRY } }while(0)
#define THROW longjmp(ex_buf__, 1)

static bool getPLA(pPLA *PLA, char *fname, int out_type, int input_type);
static bool writePLA(pcover Fold, pPLA PLA, int out_type, bool needs_verify);
static void main_clean(pcover F, pPLA PLA);
void init_runtime(void);
void runtime(void);

#define MAX_SOLUTIONS 49

void esp_main(char **esp_mode, char **esp_file)
{
TRY {
    pPLA PLA;
    pcover Fold=NULL;
    bool full_pi_cover;
    long start;
    int input_type = FD_type;
    int out_type = F_type;

    start = ptime();
    init_runtime();
    debug = 0;		
    verbose_debug = FALSE;
    single_row_mv = TRUE;
    remove_essential = TRUE;	
    force_irredundant = TRUE;
    unwrap_onset = TRUE;
    single_expand = FALSE;
    pos = FALSE;
    recompute_onset = FALSE;
    use_super_gasp = FALSE;
    use_random_order = FALSE;
    skip_make_sparse = 0;
    kiss = FALSE;
    echo_comments = TRUE;
    echo_unknown_commands = TRUE;
    full_pi_cover = FALSE;
    bool needs_verify = TRUE;
    bool exact_cover = FALSE;
    int max_solutions = 0;
    toggle = TRUE;

    summary = FALSE;	
    trace = FALSE;

    /** initialize R return values 
    return_val[0] = 0; 
    return_val[1] = 0;
    **/

    if (getenv("ESP_VERBOSE_DEBUG")) {
       verbose_debug = TRUE;
       summary = TRUE;
       trace = TRUE;
    }

    /* provide version information and summaries */
    if (summary || trace) {
	printf("# %s\n", VERSION);
    }

    PLA = NIL(PLA_t);
    if (! getPLA(&PLA, *esp_file, out_type, input_type))
       return;

    if (check_consistency(PLA, FALSE)) {
       main_clean(Fold,PLA);
       return;
    }

    if (summary || trace) {
	if (PLA != NIL(PLA_t)) PLA_summary(PLA);
    }

    /** Espresso **/
    if (strcmp(*esp_mode,"espresso") == 0) {
	Fold = sf_save(PLA->F);
	PLA->F = espresso(PLA->F, PLA->D, PLA->R);
    }

    /** Primes **/
    else if (strcmp(*esp_mode,"primes") == 0) {
        pcover E, Rt, Rp;
	PLA->F = primes_consensus(cube2list(PLA->F, PLA->D));
        irred_split_cover(PLA->F, PLA->D, &E, &Rt, &Rp);
        free_cover(PLA->F);
        PLA->F = E;
        PLA->F->sfnext = Rp;
        Rp->sfnext= Rt;
        needs_verify=FALSE;
    }

    /** Quine-McCluskey options **/ 
    else if ((strcmp(*esp_mode,"qm") == 0) ||
             (strcmp(*esp_mode,"multi-full") == 0) ||
             (strcmp(*esp_mode,"multi-min") == 0)) {

       if (getenv("ESP_EXACT_COVER")) 
          exact_cover = TRUE;

       full_pi_cover = (strcmp(*esp_mode,"multi-full") == 0);

       if (full_pi_cover || (strcmp(*esp_mode,"multi-min") == 0)) {
          max_solutions = MAX_SOLUTIONS;
       }

       Fold = sf_save(PLA->F);
       PLA->F = minimize_exact(PLA->F, PLA->D, PLA->R,exact_cover,
                               max_solutions,full_pi_cover);
    }
    else if (strcmp(*esp_mode,"echo") == 0) {
        needs_verify = FALSE;  /* don't verify */
        out_type = FDR_type; /* echo all sets */ 
    }
    else {
       printf("Unknown option %s\n", *esp_mode); 
       main_clean(Fold,PLA);
       return;
    }

    if (single_row_mv) 
        unravel_srmv_PLA(PLA, out_type); 

    /* Print a runtime summary if trace esp_mode enabled */
    if (trace) {
	runtime();
    }

    /* Print total runtime */
    if (summary || trace) {
	print_trace(PLA->F, *esp_mode, ptime()-start);
    }

    if (!writePLA(Fold, PLA, out_type, needs_verify)) {
       printf("Failed to write truth table for mode  %s\n", *esp_mode); 
    }

    main_clean(Fold,PLA);
    }
    CATCH {
        printf("Call to espresso finished with errors.\n");
    }
    ETRY;

    return;
}


static bool writePLA(pcover Fold, pPLA PLA, int out_type, bool needs_verify)
{
    FILE *fp;
    pcover plaF = PLA->F;
    pcover plaHead = PLA->F;
    bool ver_error, verified = TRUE;
    int n_sol = 0;
    char *fname;

    fname = "esptemp.out";
    if ((fp = fopen(fname, "w")) == NULL) {
        printf("Unable to open %s\n", fname);
        return FALSE;
    }

    (void) fprintf(fp,"# Truth table generated by esp_R\n");
    (void) fprintf(fp,"# %s\n", VERSION);
    while (plaF != (pcover) NULL) {
        if (needs_verify) {
           ver_error = verify(plaF,Fold,PLA->D);
	   if (ver_error) {
              verified = FALSE;
              printf(" SOLUTION %d did not verify!\n", n_sol); 
	      (void) check_consistency(PLA, TRUE);
	   }
        }

	if (verified) {
            if (n_sol == 0) {
                if (PLA->F->sfnext != (pcover) NULL)
                   (void) fprintf(fp,".solution 0\n");
            }
            else {
                (void) fprintf(fp,".solution %d\n", n_sol);
            }
            PLA->F = plaF; /* fprint_pla operates on PLA->F */
	    fprint_pla(fp, PLA, out_type);
	    (void) fflush(fp);
            plaF = plaF->sfnext;
            n_sol++;
        } 
    }
    PLA->F = plaHead; /* set PLA->F back to original head */
    fclose(fp);
   
    return verified; 
}

static bool getPLA(pPLA *PLA, char *fname, int out_type, int input_type)
{
    FILE *fp;
    int needs_dcset, needs_offset;

    needs_dcset = 1;
    needs_offset = 1;

    if ((fp = fopen(fname, "r")) == NULL) {
        printf("Unable to open %s\n", fname);
        return FALSE;
    }

    if (read_pla(fp, needs_dcset, needs_offset, input_type, PLA) == EOF) {
	printf("Unable to process truth table in file %s\n", fname);
        (void) fclose(fp);
	return FALSE;
    }
    (*PLA)->filename = Strdup(fname);
    (void) fclose(fp);
    return TRUE;
}


void runtime(void)
{
    int i;
    long total = 1, temp;

    for(i = 0; i < TIME_COUNT; i++) {
	total += total_time[i];
    }
    for(i = 0; i < TIME_COUNT; i++) {
	if (total_calls[i] != 0) {
	    temp = 100 * total_time[i];
	    printf("# %s\t%2d call(s) for %s (%2ld.%01ld%%)\n",
		total_name[i], total_calls[i], print_time(total_time[i]),
		    temp/total, (10 * (temp%total)) / total);
	}
    }
}


void init_runtime(void)
{
    total_name[READ_TIME] =     "READ       ";
    total_name[WRITE_TIME] =    "WRITE      ";
    total_name[COMPL_TIME] =    "COMPL      ";
    total_name[REDUCE_TIME] =   "REDUCE     ";
    total_name[EXPAND_TIME] =   "EXPAND     ";
    total_name[ESSEN_TIME] =    "ESSEN      ";
    total_name[IRRED_TIME] =    "IRRED      ";
    total_name[GREDUCE_TIME] =  "REDUCE_GASP";
    total_name[GEXPAND_TIME] =  "EXPAND_GASP";
    total_name[GIRRED_TIME] =   "IRRED_GASP ";
    total_name[MV_REDUCE_TIME] ="MV_REDUCE  ";
    total_name[RAISE_IN_TIME] = "RAISE_IN   ";
    total_name[VERIFY_TIME] =   "VERIFY     ";
    total_name[PRIMES_TIME] =   "PRIMES     ";
    total_name[MINCOV_TIME] =   "MINCOV     ";
}


void main_clean(pcover F, pPLA PLA)
{
    if (F) free_cover(F);
    if (PLA) free_PLA(PLA);
    FREE(cube.part_size);
    setdown_cube();
    sf_cleanup(); 
    sm_cleanup();
}
