% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusteringLC.R
\name{UPShclus}
\alias{UPShclus}
\title{Hierarchical Clustering of Patients on X-covariates for Unsupervised Propensiy Scoring}
\usage{
UPShclus(envir, dframe, xvars, method, metric)
}
\arguments{
\item{envir}{name of the working local control classic environment.}

\item{dframe}{{Name of data.frame containing baseline X covariates.}}

\item{xvars}{{List of names of X variable(s).}}

\item{method}{{Hierarchical Clustering Method: "diana", "agnes" or "hclus".}}

\item{metric}{A valid distance metric for clustering.}
}
\value{
An output list object of class UPShclus:
\itemize{ 
 \item{dframe}{Name of data.frame containing baseline X covariates.}
 \item{xvars}{List of names of X variable(s).}
 \item{method}{Hierarchical Clustering Method: "diana", "agnes" or "hclus".}
 \item{upshcl}{Hierarchical clustering object created by choice between three possible methods.}
}
}
\description{
Derive a full, hierarchical clustering tree (dendrogram) for all patients (regardless
 of treatment received) using Mahalonobis between-patient distances computed from specified
 baseline X-covariate characteristics.
}
\details{
The first step in an Unsupervised Propensity Scoring alalysis is always
 to hierarchically cluster patients in baseline X-covariate space.  UPShclus uses
 a Mahalabobis metric and clustering methods from the R "cluster" library for this
 key initial step.
}
\references{
{
 Kaufman L, Rousseeuw PJ.  (1990) \bold{Finding Groups in Data.  An Introduction to
  Cluster Analysis}.  New York: John Wiley and Sons.

 Kereiakes DJ, Obenchain RL, Barber BL, et al. (2000) Abciximab provides
  cost effective survival advantage in high volume interventional practice.
  \emph{Am Heart J} \bold{140}: 603-610.

 Obenchain RL. (2004) Unsupervised Propensity Scoring: NN and IV Plots.
  \emph{Proceedings of the American Statistical Association (on CD)} 8 pages.

 Obenchain RL. (2011) \bold{USPSinR.pdf}  USPS R-package vignette, 40 pages.

 Rubin DB. (1980) Bias reduction using Mahalanobis metric matching.
 \emph{Biometrics} \bold{36}: 293-298.
}
}
\seealso{
\code{\link{UPSaccum}}, \code{\link{UPSnnltd}} and \code{\link{UPSgraph}}.
}
\author{
Bob Obenchain <wizbob@att.net>
}
\keyword{cluster}
\keyword{design}
